/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.MatchFunctor;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensaml.xml.util.LazySet;

public class ShibbolethFilteringContext {
    private SAMLProfileRequestContext attributeRequestContext;
    private Map<String, BaseAttribute> unfilteredAttributes;
    private Map<String, Collection> retainedValues;
    private Map<String, List<MatchFunctor>> denyValueRules;

    public ShibbolethFilteringContext(Map<String, BaseAttribute> attributes, SAMLProfileRequestContext context) {
        this.attributeRequestContext = context;
        this.unfilteredAttributes = attributes;
        this.retainedValues = new HashMap<String, Collection>();
        this.denyValueRules = new HashMap<String, List<MatchFunctor>>();
    }

    public SAMLProfileRequestContext getAttributeRequestContext() {
        return this.attributeRequestContext;
    }

    public Map<String, BaseAttribute> getUnfilteredAttributes() {
        return this.unfilteredAttributes;
    }

    public Collection getRetainedValues(String attributeId, boolean prepopulate) {
        Object attributeValues;
        if (!this.retainedValues.containsKey(attributeId)) {
            BaseAttribute attribute;
            attributeValues = new LazySet();
            this.retainedValues.put(attributeId, (Collection)attributeValues);
            if (prepopulate && (attribute = this.unfilteredAttributes.get(attributeId)) != null && attribute.getValues() != null) {
                for (Object value : attribute.getValues()) {
                    if (value == null) continue;
                    attributeValues.add(value);
                }
            }
        } else {
            attributeValues = this.retainedValues.get(attributeId);
        }
        return attributeValues;
    }

    public Map<String, List<MatchFunctor>> getDenyValueRules() {
        return this.denyValueRules;
    }
}

