/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.encoding.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML1NameIdentifierEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.provider.AbstractAttributeEncoder;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.xml.util.DatatypeHelper;

public class SAML1StringNameIdentifierEncoder
extends AbstractAttributeEncoder<NameIdentifier>
implements SAML1NameIdentifierEncoder {
    private SAMLObjectBuilder<NameIdentifier> identifierBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(NameIdentifier.DEFAULT_ELEMENT_NAME);
    private String nameFormat;
    private String nameQualifier;

    @Override
    public String getNameFormat() {
        return this.nameFormat;
    }

    @Override
    public void setNameFormat(String format) {
        this.nameFormat = DatatypeHelper.safeTrimOrNullString((String)format);
    }

    @Override
    public String getNameQualifier() {
        return this.nameQualifier;
    }

    @Override
    public void setNameQualifier(String qualifier) {
        this.nameQualifier = DatatypeHelper.safeTrimOrNullString((String)qualifier);
    }

    @Override
    public NameIdentifier encode(BaseAttribute attribute) throws AttributeEncodingException {
        if (attribute.getValues() != null) {
            for (Object value : attribute.getValues()) {
                String valueStr = value.toString();
                if (DatatypeHelper.safeTrimOrNullString((String)valueStr) == null) continue;
                NameIdentifier nameId = (NameIdentifier)this.identifierBuilder.buildObject();
                nameId.setNameIdentifier(valueStr);
                if (this.nameFormat != null) {
                    nameId.setFormat(this.nameFormat);
                }
                if (this.nameQualifier != null) {
                    nameId.setNameQualifier(this.nameQualifier);
                }
                return nameId;
            }
        }
        throw new AttributeEncodingException(attribute.getId() + " attribute does not contain any non-empty values to encode");
    }
}

