/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.idp.ui.ServiceTagSupport;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationName;
import org.owasp.esapi.ESAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationNameTag
extends ServiceTagSupport {
    private static final long serialVersionUID = -6900646580035644134L;
    private static Logger log = LoggerFactory.getLogger(OrganizationNameTag.class);

    private String getOrganizationName() {
        Organization org = this.getSPOrganization();
        if (org != null && org.getOrganizationNames() != null) {
            for (String lang : this.getBrowserLanguages()) {
                for (OrganizationName name : org.getOrganizationNames()) {
                    if (name.getName() == null || name.getName().getLanguage() == null) continue;
                    log.debug("Found OrganizationName in Organization, language={}", (Object)name.getName().getLanguage());
                    if (!name.getName().getLanguage().equals(lang)) continue;
                    log.debug("returning OrganizationName from Organization, {}", (Object)name.getName().getLocalString());
                    return name.getName().getLocalString();
                }
            }
            log.debug("No relevant OrganizationName in Organization");
        }
        return null;
    }

    public int doEndTag() throws JspException {
        String name = this.getOrganizationName();
        try {
            if (null == name) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(ESAPI.encoder().encodeForHTML(name));
            }
        }
        catch (IOException e) {
            log.warn("Error generating OrganizationName");
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

