/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.session;

import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class IdPSessionFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(IdPSessionFilter.class);
    private String cookieDomain;
    private boolean consistentAddress;
    private SessionManager<Session> sessionManager;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        MDC.put((String)"JSESSIONID", (String)httpRequest.getSession().getId());
        MDC.put((String)"clientIP", (String)httpRequest.getRemoteAddr());
        Cookie sessionCookie = this.getIdPSessionCookie(httpRequest);
        Session idpSession = this.getUserSession(sessionCookie, httpRequest, (HttpServletResponse)response);
        if (idpSession != null) {
            this.log.trace("Updating IdP session activity time and adding session object to the request");
            idpSession.setLastActivityInstant(new DateTime());
            MDC.put((String)"idpSessionId", (String)idpSession.getSessionID());
            httpRequest.setAttribute("ShibbolethIdPSession", (Object)idpSession);
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.cookieDomain = HttpServletHelper.getCookieDomain(filterConfig.getServletContext());
        String sessionManagerId = filterConfig.getInitParameter("sessionManagedId");
        if (DatatypeHelper.isEmpty((String)sessionManagerId)) {
            sessionManagerId = "shibboleth.SessionManager";
        }
        this.sessionManager = (SessionManager)filterConfig.getServletContext().getAttribute(sessionManagerId);
        String consistentAddressParam = filterConfig.getInitParameter("ensureConsistentClientAddress");
        this.consistentAddress = DatatypeHelper.isEmpty((String)consistentAddressParam) ? true : Boolean.parseBoolean(consistentAddressParam);
    }

    protected Cookie getIdPSessionCookie(HttpServletRequest httpRequest) {
        this.log.trace("Attempting to retrieve IdP session cookie.");
        Cookie[] requestCookies = httpRequest.getCookies();
        if (requestCookies != null) {
            for (Cookie requestCookie : requestCookies) {
                if (!DatatypeHelper.safeEquals((Object)requestCookie.getName(), (Object)"_idp_session")) continue;
                this.log.trace("Found IdP session cookie.");
                return requestCookie;
            }
        }
        return null;
    }

    protected Session getUserSession(Cookie sessionCookie, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (sessionCookie == null || DatatypeHelper.isEmpty((String)sessionCookie.getValue())) {
            return null;
        }
        String cookieValue = HTTPTransportUtils.urlDecode((String)sessionCookie.getValue());
        String[] valueComponents = cookieValue.split("\\|");
        if (valueComponents.length != 4) {
            if (valueComponents.length == 3) {
                this.log.debug("IdP session cookie probably issued by older IdP version, ignoring it");
            } else {
                this.log.warn("IdP session cookie has an improperly formatted value: {}", (Object)cookieValue);
            }
            return null;
        }
        byte[] v4AddressBytes = Base64.decode((String)valueComponents[0]);
        byte[] v6AddressBytes = Base64.decode((String)valueComponents[1]);
        byte[] sessionIdBytes = Base64.decode((String)valueComponents[2]);
        byte[] signatureBytes = Base64.decode((String)valueComponents[3]);
        if (v4AddressBytes == null || v6AddressBytes == null || sessionIdBytes == null || signatureBytes == null) {
            this.log.warn("A session cookie field was null");
            return null;
        }
        String sessionId = new String(sessionIdBytes);
        Session userSession = (Session)this.sessionManager.getSession(sessionId);
        if (userSession != null) {
            if (this.isCookieValid(httpRequest, httpResponse, v4AddressBytes, v6AddressBytes, sessionIdBytes, signatureBytes, userSession.getSessionSecret())) {
                return userSession;
            }
        } else {
            this.log.debug("No session associated with session ID {} - session must have timed out", (Object)sessionId);
        }
        return null;
    }

    protected boolean isCookieValid(HttpServletRequest httpRequest, HttpServletResponse httpResponse, byte[] v4AddressBytes, byte[] v6AddressBytes, byte[] sessionIdBytes, byte[] signatureBytes, byte[] sessionSecret) {
        boolean isV4 = false;
        String sessionAddress = null;
        String clientAddress = null;
        if (this.consistentAddress && !(sessionAddress = new String((isV4 = (clientAddress = httpRequest.getRemoteAddr()).contains(".")) ? v4AddressBytes : v6AddressBytes)).equals("-") && !clientAddress.equals(sessionAddress)) {
            this.log.warn("Client sent a cookie from address {} but the cookie was issued to address {}", (Object)clientAddress, (Object)sessionAddress);
            return false;
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA");
            digester.update(sessionSecret);
            digester.update(v4AddressBytes);
            digester.update(v6AddressBytes);
            digester.update(sessionIdBytes);
            if (!Arrays.equals(digester.digest(), signatureBytes)) {
                this.log.error("Session cookie has been tampered with, its signature no longer matches expected value");
                return false;
            }
        }
        catch (GeneralSecurityException e) {
            this.log.error("Unable to compute signature over session cookie material", (Throwable)e);
            return false;
        }
        if (this.consistentAddress && sessionAddress.equals("-")) {
            this.log.info("Session not yet locked to a {} address, locking it to {}", (Object)(isV4 ? "V4" : "V6"), (Object)clientAddress);
            if (isV4) {
                v4AddressBytes = clientAddress.getBytes();
            } else {
                v6AddressBytes = clientAddress.getBytes();
            }
            String signature = null;
            try {
                MessageDigest digester = MessageDigest.getInstance("SHA");
                digester.update(sessionSecret);
                digester.update(v4AddressBytes);
                digester.update(v6AddressBytes);
                digester.update(sessionIdBytes);
                signature = Base64.encodeBytes((byte[])digester.digest());
            }
            catch (GeneralSecurityException e) {
                this.log.error("Unable to compute signature over session cookie material", (Throwable)e);
                return false;
            }
            this.log.debug("Updating IdP session cookie via HTTP response");
            StringBuilder cookieValue = new StringBuilder();
            cookieValue.append(Base64.encodeBytes((byte[])v4AddressBytes, (int)8)).append("|");
            cookieValue.append(Base64.encodeBytes((byte[])v6AddressBytes, (int)8)).append("|");
            cookieValue.append(Base64.encodeBytes((byte[])sessionIdBytes, (int)8)).append("|");
            cookieValue.append(signature);
            Cookie sessionCookie = new Cookie("_idp_session", HTTPTransportUtils.urlEncode((String)cookieValue.toString()));
            sessionCookie.setVersion(1);
            if (this.cookieDomain != null) {
                sessionCookie.setDomain(this.cookieDomain);
            }
            sessionCookie.setPath("".equals(httpRequest.getContextPath()) ? "/" : httpRequest.getContextPath());
            sessionCookie.setSecure(httpRequest.isSecure());
            httpResponse.addCookie(sessionCookie);
        }
        return true;
    }
}

