/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.auth.handler;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.auth.AuthorizationException;
import edu.vt.middleware.ldap.auth.handler.AuthenticationCriteria;
import edu.vt.middleware.ldap.auth.handler.AuthorizationHandler;
import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompareAuthorizationHandler
implements AuthorizationHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SearchFilter searchFilter;

    public CompareAuthorizationHandler() {
    }

    public CompareAuthorizationHandler(SearchFilter sf) {
        this.searchFilter = sf;
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(SearchFilter sf) {
        this.searchFilter = sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(AuthenticationCriteria ac, LdapContext ctx) throws NamingException {
        ArrayList<Object> filterArgs = new ArrayList<Object>();
        filterArgs.add(ac.getDn());
        filterArgs.addAll(this.searchFilter.getFilterArgs());
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(ac.getDn(), this.searchFilter.getFilter(), filterArgs.toArray(), LdapConfig.getCompareSearchControls());
            if (!results.hasMore()) {
                throw new AuthorizationException("Compare failed");
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    public String toString() {
        return String.format("%s::%s", this.getClass().getName(), this.searchFilter);
    }
}

