/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.AbstractCli;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.dsml.Dsmlv1;
import edu.vt.middleware.ldap.dsml.Dsmlv2;
import edu.vt.middleware.ldap.ldif.Ldif;
import edu.vt.middleware.ldap.props.LdapConfigPropertyInvoker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.naming.directory.SearchResult;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class LdapCli
extends AbstractCli {
    protected static final String OPT_QUERY = "query";
    private static final String COMMAND_NAME = "ldapsearch";

    public LdapCli() {
        this.opts.add(OPT_QUERY);
    }

    public static void main(String[] args) {
        new LdapCli().performAction(args);
    }

    protected void initOptions() {
        super.initOptions(new LdapConfigPropertyInvoker(LdapConfig.class, "edu.vt.middleware.ldap."));
        this.options.addOption(new Option(OPT_QUERY, true, ""));
    }

    protected LdapConfig initLdapConfig(CommandLine line) throws Exception {
        LdapConfig config = new LdapConfig();
        this.initLdapProperties(config, line);
        if (line.hasOption("trace")) {
            config.setTracePackets(System.out);
        }
        if (config.getBindDn() != null && config.getBindCredential() == null) {
            System.out.print("Enter password for service user " + config.getBindDn() + ": ");
            String pass = new BufferedReader(new InputStreamReader(System.in)).readLine();
            config.setBindCredential(pass);
        }
        return config;
    }

    protected void dispatch(CommandLine line) throws Exception {
        if (line.hasOption("dsmlv1")) {
            this.outputDsmlv1 = true;
        } else if (line.hasOption("dsmlv2")) {
            this.outputDsmlv2 = true;
        }
        if (line.hasOption("help")) {
            this.printHelp();
        } else if (line.hasOption(OPT_QUERY)) {
            this.search(this.initLdapConfig(line), line.getOptionValue(OPT_QUERY), line.getArgs());
        } else {
            this.printExamples();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void search(LdapConfig config, String filter, String[] attrs) throws Exception {
        Ldap ldap = new Ldap();
        ldap.setLdapConfig(config);
        try {
            Iterator<SearchResult> results = null;
            results = attrs == null || attrs.length == 0 ? ldap.search(new SearchFilter(filter)) : ldap.search(new SearchFilter(filter), attrs);
            if (this.outputDsmlv1) {
                new Dsmlv1().outputDsml(results, (Writer)new BufferedWriter(new OutputStreamWriter(System.out)));
            } else if (this.outputDsmlv2) {
                new Dsmlv2().outputDsml(results, (Writer)new BufferedWriter(new OutputStreamWriter(System.out)));
            } else {
                new Ldif().outputLdif(results, (Writer)new BufferedWriter(new OutputStreamWriter(System.out)));
            }
        }
        finally {
            if (ldap != null) {
                ldap.close();
            }
        }
    }

    protected String getCommandName() {
        return COMMAND_NAME;
    }
}

