/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.BaseLdap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.handler.AttributeHandler;
import edu.vt.middleware.ldap.handler.AttributesProcessor;
import edu.vt.middleware.ldap.handler.ConnectionHandler;
import edu.vt.middleware.ldap.handler.CopyResultHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import edu.vt.middleware.ldap.handler.SearchResultHandler;
import edu.vt.middleware.ldap.props.AbstractPropertyConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLdap<T extends LdapConfig>
implements BaseLdap {
    protected static final CopyResultHandler<SearchResult> SR_COPY_RESULT_HANDLER = new CopyResultHandler();
    protected static final CopyResultHandler<NameClassPair> NCP_COPY_RESULT_HANDLER = new CopyResultHandler();
    protected static final CopyResultHandler<Binding> BINDING_COPY_RESULT_HANDLER = new CopyResultHandler();
    protected static final CopyResultHandler<Object> COPY_RESULT_HANDLER = new CopyResultHandler();
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ConnectionHandler connectionHandler;
    protected T config;

    protected void setLdapConfig(T ldapConfig) {
        if (this.config != null) {
            ((AbstractPropertyConfig)this.config).checkImmutable();
        }
        this.config = ldapConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compare(String dn, String filter, Object[] filterArgs) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Compare with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            this.logger.debug((Object)("  filter = " + filter));
            this.logger.debug((Object)("  filterArgs = " + Arrays.toString(filterArgs)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        boolean success = false;
        Context ctx = null;
        NamingEnumeration<SearchResult> en = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    en = ctx.search(dn, filter, filterArgs, LdapConfig.getCompareSearchControls());
                    if (en.hasMore()) {
                        success = true;
                    }
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (en != null) {
                en.close();
            }
            if (ctx != null) {
                ctx.close();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<SearchResult> search(String dn, String filter, Object[] filterArgs, SearchControls searchControls, SearchResultHandler ... handler) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Search with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            this.logger.debug((Object)("  filter = " + filter));
            this.logger.debug((Object)("  filterArgs = " + Arrays.toString(filterArgs)));
            this.logger.debug((Object)("  searchControls = " + searchControls));
            this.logger.debug((Object)("  handler = " + Arrays.toString(handler)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        List results = null;
        Context ctx = null;
        NamingEnumeration<SearchResult> en = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    en = ctx.search(dn, filter, filterArgs, searchControls);
                    if (handler != null && handler.length > 0) {
                        SearchCriteria sc = new SearchCriteria();
                        if (ctx != null && !"".equals(ctx.getNameInNamespace())) {
                            sc.setDn(ctx.getNameInNamespace());
                        } else {
                            sc.setDn(dn);
                        }
                        sc.setFilter(filter);
                        sc.setFilterArgs(filterArgs);
                        if (searchControls != null) {
                            sc.setReturnAttrs(searchControls.getReturningAttributes());
                        }
                        for (int j = 0; j < handler.length; ++j) {
                            results = j == 0 ? handler[j].process(sc, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions()) : handler[j].process(sc, results);
                        }
                    } else {
                        results = SR_COPY_RESULT_HANDLER.process(null, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions());
                    }
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (en != null) {
                en.close();
            }
            if (ctx != null) {
                ctx.close();
            }
        }
        return results.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<SearchResult> pagedSearch(String dn, String filter, Object[] filterArgs, SearchControls searchControls, SearchResultHandler ... handler) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Paginated search with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            this.logger.debug((Object)("  filter = " + filter));
            this.logger.debug((Object)("  filterArgs = " + Arrays.toString(filterArgs)));
            this.logger.debug((Object)("  searchControls = " + searchControls));
            this.logger.debug((Object)("  handler = " + Arrays.toString(handler)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        ArrayList results = new ArrayList();
        Context ctx = null;
        NamingEnumeration<SearchResult> en = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    byte[] cookie = null;
                    ctx = this.getContext();
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(((LdapConfig)this.config).getPagedResultsSize(), true)});
                    do {
                        int j;
                        List pagedResults = null;
                        en = ctx.search(dn, filter, filterArgs, searchControls);
                        if (handler != null && handler.length > 0) {
                            SearchCriteria sc = new SearchCriteria();
                            if (ctx != null && !"".equals(ctx.getNameInNamespace())) {
                                sc.setDn(ctx.getNameInNamespace());
                            } else {
                                sc.setDn(dn);
                            }
                            sc.setFilter(filter);
                            sc.setFilterArgs(filterArgs);
                            if (searchControls != null) {
                                sc.setReturnAttrs(searchControls.getReturningAttributes());
                            }
                            for (j = 0; j < handler.length; ++j) {
                                pagedResults = j == 0 ? handler[j].process(sc, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions()) : handler[j].process(sc, pagedResults);
                            }
                        } else {
                            pagedResults = SR_COPY_RESULT_HANDLER.process(null, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions());
                        }
                        results.addAll(pagedResults);
                        Control[] controls = ctx.getResponseControls();
                        if (controls != null) {
                            for (j = 0; j < controls.length; ++j) {
                                if (!(controls[j] instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[j];
                                cookie = prrc.getCookie();
                            }
                        }
                        ctx.setRequestControls(new Control[]{new PagedResultsControl(((LdapConfig)this.config).getPagedResultsSize(), cookie, true)});
                    } while (cookie != null);
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
                catch (IOException e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)"Could not encode page size into control", (Throwable)e);
                    }
                    throw new NamingException(e.getMessage());
                }
            }
        }
        finally {
            if (en != null) {
                en.close();
            }
            if (ctx != null) {
                ctx.close();
            }
        }
        return results.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<SearchResult> searchAttributes(String dn, Attributes matchAttrs, String[] retAttrs, SearchResultHandler ... handler) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"One level search with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            this.logger.debug((Object)("  matchAttrs = " + matchAttrs));
            this.logger.debug((Object)("  retAttrs = " + (retAttrs == null ? "all attributes" : Arrays.toString(retAttrs))));
            this.logger.debug((Object)("  handler = " + Arrays.toString(handler)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        List results = null;
        Context ctx = null;
        NamingEnumeration<SearchResult> en = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    en = ctx.search(dn, matchAttrs, retAttrs);
                    if (handler != null && handler.length > 0) {
                        SearchCriteria sc = new SearchCriteria();
                        if (ctx != null && !"".equals(ctx.getNameInNamespace())) {
                            sc.setDn(ctx.getNameInNamespace());
                        } else {
                            sc.setDn(dn);
                        }
                        sc.setMatchAttrs(matchAttrs);
                        sc.setReturnAttrs(retAttrs);
                        if (handler != null && handler.length > 0) {
                            for (int j = 0; j < handler.length; ++j) {
                                results = j == 0 ? handler[j].process(sc, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions()) : handler[j].process(sc, results);
                            }
                        }
                    } else {
                        results = SR_COPY_RESULT_HANDLER.process(null, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions());
                    }
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (en != null) {
                en.close();
            }
            if (ctx != null) {
                ctx.close();
            }
        }
        return results.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<NameClassPair> list(String dn) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"list with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        List results = null;
        Context ctx = null;
        NamingEnumeration<NameClassPair> en = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    en = ctx.list(dn);
                    results = NCP_COPY_RESULT_HANDLER.process(null, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions());
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (en != null) {
                en.close();
            }
            if (ctx != null) {
                ctx.close();
            }
        }
        return results.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<Binding> listBindings(String dn) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"listBindings with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        List results = null;
        Context ctx = null;
        NamingEnumeration<Binding> en = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    en = ctx.listBindings(dn);
                    results = BINDING_COPY_RESULT_HANDLER.process(null, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions());
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (en != null) {
                en.close();
            }
            if (ctx != null) {
                ctx.close();
            }
        }
        return results.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Attributes getAttributes(String dn, String[] retAttrs, AttributeHandler ... handler) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Attribute search with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            this.logger.debug((Object)("  retAttrs = " + (retAttrs == null ? "all attributes" : Arrays.toString(retAttrs))));
            this.logger.debug((Object)("  handler = " + Arrays.toString(handler)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        Context ctx = null;
        Attributes attrs = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    attrs = ctx.getAttributes(dn, retAttrs);
                    if (handler != null && handler.length > 0) {
                        SearchCriteria sc = new SearchCriteria();
                        if (ctx != null && !"".equals(ctx.getNameInNamespace())) {
                            sc.setDn(ctx.getNameInNamespace());
                        } else {
                            sc.setDn(dn);
                        }
                        for (int j = 0; j < handler.length; ++j) {
                            attrs = AttributesProcessor.executeHandler(sc, attrs, handler[j], ((LdapConfig)this.config).getHandlerIgnoreExceptions());
                        }
                    }
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<SearchResult> getSchema(String dn) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Schema search with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        List results = null;
        Context ctx = null;
        Context schema = null;
        NamingEnumeration<SearchResult> en = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    schema = ctx.getSchema(dn);
                    en = schema.search("", null);
                    results = SR_COPY_RESULT_HANDLER.process(null, en, ((LdapConfig)this.config).getHandlerIgnoreExceptions());
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (schema != null) {
                schema.close();
            }
            if (en != null) {
                en.close();
            }
            if (ctx != null) {
                ctx.close();
            }
        }
        return results.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyAttributes(String dn, int modOp, Attributes attrs) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Modify attributes with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            this.logger.debug((Object)("  modOp = " + modOp));
            this.logger.debug((Object)("  attrs = " + attrs));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        Context ctx = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    ctx.modifyAttributes(dn, modOp, attrs);
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyAttributes(String dn, ModificationItem[] mods) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Modify attributes with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            this.logger.debug((Object)("  mods = " + Arrays.toString(mods)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        Context ctx = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    ctx.modifyAttributes(dn, mods);
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(String dn, Attributes attrs) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Create name with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            this.logger.debug((Object)("  attrs = " + attrs));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        Context ctx = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    ctx.createSubcontext(dn, attrs).close();
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rename(String oldDn, String newDn) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Rename name with the following parameters:");
            this.logger.debug((Object)("  oldDn = " + oldDn));
            this.logger.debug((Object)("  newDn = " + newDn));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        Context ctx = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    ctx.rename(oldDn, newDn);
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(String dn) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Delete name with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + ((LdapConfig)this.config).getEnvironment()));
            }
        }
        Context ctx = null;
        try {
            for (int i = 0; i <= ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1; ++i) {
                try {
                    ctx = this.getContext();
                    ctx.destroySubcontext(dn);
                    break;
                }
                catch (NamingException e) {
                    this.operationRetry((LdapContext)ctx, e, i);
                    continue;
                }
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    @Override
    public synchronized boolean connect() throws NamingException {
        boolean success = false;
        if (this.connectionHandler == null) {
            this.connectionHandler = ((LdapConfig)this.config).getConnectionHandler().newInstance();
        }
        if (this.connectionHandler.isConnected()) {
            success = true;
        } else {
            this.connectionHandler.connect(((LdapConfig)this.config).getBindDn(), ((LdapConfig)this.config).getBindCredential());
            success = true;
        }
        return success;
    }

    @Override
    public synchronized boolean reconnect() throws NamingException {
        this.close();
        return this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.connectionHandler != null) {
            try {
                this.connectionHandler.close();
            }
            catch (NamingException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"Error closing connection with the LDAP", (Throwable)e);
                }
            }
            finally {
                this.connectionHandler = null;
            }
        }
    }

    protected LdapContext getContext() throws NamingException {
        this.connect();
        if (this.connectionHandler != null && this.connectionHandler.isConnected()) {
            return this.connectionHandler.getLdapContext().newInstance(null);
        }
        return null;
    }

    protected void operationRetry(LdapContext ctx, NamingException e, int count) throws NamingException {
        boolean ignoreException = false;
        Class<?>[] ignore = ((LdapConfig)this.config).getOperationRetryExceptions();
        if (ignore != null && ignore.length > 0) {
            for (Class<?> ne : ignore) {
                if (!ne.isInstance(e)) continue;
                ignoreException = true;
                break;
            }
        }
        if (ignoreException && (count < ((LdapConfig)this.config).getOperationRetry() || ((LdapConfig)this.config).getOperationRetry() == -1)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Error performing LDAP operation, retrying (attempt " + count + ")"), (Throwable)e);
            }
            if (ctx != null) {
                ctx.close();
            }
            this.close();
            if (((LdapConfig)this.config).getOperationRetryWait() > 0L) {
                long sleepTime = ((LdapConfig)this.config).getOperationRetryWait();
                if (((LdapConfig)this.config).getOperationRetryBackoff() > 0 && count > 0) {
                    sleepTime = sleepTime * (long)((LdapConfig)this.config).getOperationRetryBackoff() * (long)count;
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Operation retry wait interrupted", (Throwable)e);
                    }
                }
            }
        } else {
            throw e;
        }
    }

    public String toString() {
        return String.format("%s@%d::config=%s", this.getClass().getName(), this.hashCode(), this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

