/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.management.provider.MBeanRegistrationProvider;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderException;
import net.sf.ehcache.management.sampled.SampledCache;
import net.sf.ehcache.management.sampled.SampledCacheManager;
import net.sf.ehcache.management.sampled.SampledEhcacheMBeans;
import net.sf.ehcache.store.StoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampledMBeanRegistrationProvider
implements MBeanRegistrationProvider,
CacheManagerEventListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)SampledMBeanRegistrationProvider.class.getName());
    private static final int MAX_MBEAN_REGISTRATION_RETRIES = 50;
    private volatile Status status = Status.STATUS_UNINITIALISED;
    private CacheManager cacheManager;
    private StoreFactory storeFactory;
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private volatile String registeredCacheManagerName;

    public void initialize(CacheManager cacheManagerParam, StoreFactory storeFactory) {
        if (this.isAlive()) {
            return;
        }
        this.status = Status.STATUS_ALIVE;
        this.cacheManager = cacheManagerParam;
        this.storeFactory = storeFactory;
        SampledCacheManager cacheManagerMBean = new SampledCacheManager(this.cacheManager);
        try {
            this.registerCacheManagerMBean(cacheManagerMBean);
        }
        catch (Exception e) {
            this.status = Status.STATUS_UNINITIALISED;
            throw new CacheException(e);
        }
        this.cacheManager.getCacheManagerEventListenerRegistry().registerListener(this);
    }

    private void registerCacheManagerMBean(SampledCacheManager cacheManagerMBean) throws Exception {
        String[] caches;
        int tries = 0;
        boolean success = false;
        InstanceAlreadyExistsException exception = null;
        while (true) {
            this.registeredCacheManagerName = this.cacheManager.getName();
            if (tries != 0) {
                this.registeredCacheManagerName = this.registeredCacheManagerName + "_" + tries;
            }
            try {
                this.mBeanServer.registerMBean(cacheManagerMBean, SampledEhcacheMBeans.getCacheManagerObjectName(this.storeFactory, this.registeredCacheManagerName));
                success = true;
                cacheManagerMBean.setMBeanRegisteredName(this.registeredCacheManagerName);
            }
            catch (InstanceAlreadyExistsException e) {
                success = false;
                exception = e;
                if (++tries < 50) continue;
            }
            break;
        }
        if (!success) {
            throw new Exception("Cannot register mbean for CacheManager with name" + this.cacheManager.getName() + " after " + 50 + " retries. Last tried name=" + this.registeredCacheManagerName, exception);
        }
        for (String cacheName : caches = this.cacheManager.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            this.registerCacheMBean(cache);
        }
    }

    public void reinitialize() throws MBeanRegistrationProviderException {
        this.dispose();
        this.initialize(this.cacheManager, this.storeFactory);
    }

    public void init() throws CacheException {
    }

    private void registerCacheMBean(Ehcache cache) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        cache.setSampledStatisticsEnabled(true);
        SampledCache terracottaCacheMBean = new SampledCache(cache);
        try {
            this.mBeanServer.registerMBean(terracottaCacheMBean, SampledEhcacheMBeans.getCacheObjectName(this.storeFactory, this.registeredCacheManagerName, terracottaCacheMBean.getImmutableCacheName()));
        }
        catch (MalformedObjectNameException e) {
            throw new MBeanRegistrationException(e);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void dispose() throws CacheException {
        if (!this.isAlive()) {
            return;
        }
        Set<ObjectName> registeredObjectNames = null;
        try {
            registeredObjectNames = this.mBeanServer.queryNames(SampledEhcacheMBeans.getCacheManagerObjectName(this.storeFactory, this.registeredCacheManagerName), null);
            registeredObjectNames.addAll(this.mBeanServer.queryNames(SampledEhcacheMBeans.getQueryCacheManagerObjectName(this.storeFactory, this.registeredCacheManagerName), null));
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Error querying MBeanServer. Error was " + e.getMessage(), (Throwable)e);
        }
        for (ObjectName objectName : registeredObjectNames) {
            try {
                this.mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                LOG.warn("Error unregistering object instance " + objectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
        this.status = Status.STATUS_SHUTDOWN;
    }

    public boolean isAlive() {
        return this.status == Status.STATUS_ALIVE;
    }

    public void notifyCacheAdded(String cacheName) {
        if (!this.isAlive()) {
            return;
        }
        try {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            this.registerCacheMBean(cache);
        }
        catch (Exception e) {
            LOG.warn("Error registering cache for management for " + cacheName + " . Error was " + e.getMessage(), (Throwable)e);
        }
    }

    public void notifyCacheRemoved(String cacheName) {
        if (!this.isAlive()) {
            return;
        }
        ObjectName objectName = null;
        try {
            objectName = SampledEhcacheMBeans.getCacheObjectName(this.storeFactory, this.registeredCacheManagerName, cacheName);
            this.mBeanServer.unregisterMBean(objectName);
        }
        catch (Exception e) {
            LOG.warn("Error unregistering cache for management for " + objectName + " . Error was " + e.getMessage(), (Throwable)e);
        }
    }
}

