/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml2;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.AbstractSAMLProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml2.LogoutRequestConfiguration;
import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.AbstractSAML2ProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.BaseSAML2ProfileRequestContext;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.samlext.saml2aslo.Asynchronous;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;
import org.owasp.esapi.ESAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLOProfileHandler
extends AbstractSAML2ProfileHandler {
    public static final String LOCAL_LOGOUT_BINDING = "urn:mace:shibboleth:2.0:profiles:LocalLogout";
    public static final String HTTP_LOGOUT_BINDING_ATTRIBUTE = "ShibbolethLogoutSession";
    public static final String HTTP_LOGOUT_REQUEST_CONTEXT_ATTRIBUTE = "ShibbolethLogoutRequestContext";
    private final String soapFaultResponseMessage = "<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"> <env:Body> <env:Fault> <faultcode>env:Client</faultcode> <faultstring>An error occurred processing the request.</faultstring> <detail/> </env:Fault> </env:Body></env:Envelope>";
    private final Logger log = LoggerFactory.getLogger(SLOProfileHandler.class);
    private final SAMLObjectBuilder<SingleLogoutService> sloServiceBuilder;
    private final SAMLObjectBuilder<LogoutResponse> responseBuilder;
    private VelocityEngine velocity;
    private String templatePath;

    public SLOProfileHandler(String newPath) {
        if (DatatypeHelper.isEmpty((String)newPath)) {
            throw new IllegalArgumentException("Logout template path may not be null");
        }
        this.templatePath = newPath;
        this.sloServiceBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        this.responseBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(LogoutResponse.DEFAULT_ELEMENT_NAME);
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocity;
    }

    public void setVelocityEngine(VelocityEngine newVelocity) {
        this.velocity = newVelocity;
    }

    public String getProfileId() {
        return "urn:mace:shibboleth:2.0:profiles:saml2:logout";
    }

    public void processRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        if (this.getInboundBinding().equals(LOCAL_LOGOUT_BINDING)) {
            this.log.debug("Processing logout request");
            this.localLogout(null, inTransport, outTransport, null);
        } else {
            this.log.debug("Processing incoming SAML LogoutRequest");
            this.processLogoutRequest(inTransport, outTransport);
        }
    }

    protected void localLogout(Session indirect, HTTPInTransport inTransport, HTTPOutTransport outTransport, SLORequestContext requestContext) throws ProfileException {
        HttpServletRequest request = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        HttpServletResponse response = ((HttpServletResponseAdapter)outTransport).getWrappedResponse();
        Session activeSession = this.getUserSession((InTransport)inTransport);
        if (indirect != null) {
            this.log.info("Invalidating session identified by LogoutRequest: {}", (Object)indirect.getSessionID());
            this.destroySession(indirect);
        }
        if (activeSession != null) {
            if (indirect == null || !DatatypeHelper.safeEquals((Object)activeSession.getSessionID(), (Object)indirect.getSessionID())) {
                this.log.info("Invalidating session identified from client request: {}", (Object)activeSession.getSessionID());
                this.destroySession(activeSession);
            }
        } else {
            this.log.info("No session to invalidate from client request.");
        }
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "content=\"no-store,no-cache,must-revalidate\"");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
        Cookie c = HttpServletHelper.getCookie(request, "_idp_session");
        if (c != null) {
            c.setValue("");
            String d = HttpServletHelper.getCookieDomain(request.getSession().getServletContext());
            if (d != null) {
                c.setDomain(d);
            }
            c.setPath(request.getContextPath());
            c.setMaxAge(0);
            response.addCookie(c);
        }
        if (this.velocity != null) {
            VelocityContext vCtx = new VelocityContext();
            vCtx.put("encoder", (Object)ESAPI.encoder());
            vCtx.put("request", (Object)request);
            vCtx.put("response", (Object)response);
            vCtx.put("session", (Object)(activeSession != null ? activeSession : indirect));
            vCtx.put(HTTP_LOGOUT_REQUEST_CONTEXT_ATTRIBUTE, (Object)requestContext);
            try {
                Template template = this.velocity.getTemplate(this.templatePath);
                PrintWriter writer = response.getWriter();
                template.merge((Context)vCtx, (Writer)writer);
                writer.flush();
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
                throw new ProfileException("Error while processing logout template.", (Throwable)e);
            }
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(this.templatePath.startsWith("/") ? this.templatePath : "/" + this.templatePath);
        try {
            request.setAttribute(HTTP_LOGOUT_BINDING_ATTRIBUTE, (Object)(activeSession != null ? activeSession : indirect));
            request.setAttribute(HTTP_LOGOUT_REQUEST_CONTEXT_ATTRIBUTE, (Object)requestContext);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new ProfileException("Could not dispatch to JSP page.", (Throwable)e);
        }
    }

    protected void processLogoutRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        LogoutResponse samlResponse = null;
        SLORequestContext requestContext = new SLORequestContext();
        try {
            this.decodeRequest(requestContext, inTransport, outTransport);
            ProfileConfiguration sloConfig = requestContext.getRelyingPartyConfiguration().getProfileConfiguration(this.getProfileId());
            if (sloConfig == null) {
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "SAML 2 SLO profile not configured"));
                String msg = "SAML 2 SLO profile is not configured for relying party " + requestContext.getInboundMessageIssuer();
                this.log.warn(msg);
                throw new ProfileException(msg);
            }
            this.checkSamlVersion(requestContext);
            SessionManager sessionManager = this.getSessionManager();
            String nameIDIndex = this.getSessionIndexFromNameID((NameID)requestContext.getSubjectNameIdentifier());
            this.log.debug("Querying SessionManager based on NameID '{}'", (Object)nameIDIndex);
            Session indexedSession = (Session)sessionManager.getSession(nameIDIndex);
            Status status = null;
            if (indexedSession == null) {
                this.log.info("LogoutRequest did not reference an active session.");
                status = this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", null);
            } else if (!indexedSession.getServicesInformation().keySet().contains(requestContext.getInboundMessageIssuer())) {
                indexedSession = null;
                this.log.warn("Requesting entity is not a participant in the referenced session.");
                status = this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", null);
            } else if (this.getInboundBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                status = indexedSession.getServicesInformation().keySet().size() > 1 ? this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "urn:oasis:names:tc:SAML:2.0:status:PartialLogout", null) : this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null, null);
            } else {
                Session activeSession = this.getUserSession((InTransport)inTransport);
                if (activeSession == null || DatatypeHelper.safeEquals((Object)activeSession.getSessionID(), (Object)indexedSession.getSessionID())) {
                    status = indexedSession.getServicesInformation().keySet().size() > 1 ? this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "urn:oasis:names:tc:SAML:2.0:status:PartialLogout", null) : this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null, null);
                } else {
                    indexedSession = null;
                    this.log.warn("LogoutRequest referenced a session other than the client's current one.");
                    status = this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", null);
                }
            }
            if (requestContext.isAsynchronous()) {
                if (this.getInboundBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                    if (indexedSession != null) {
                        this.log.info("Invalidating session identified by LogoutRequest: {}", (Object)indexedSession.getSessionID());
                        this.destroySession(indexedSession);
                    }
                    try {
                        outTransport.setCharacterEncoding("UTF-8");
                        outTransport.setHeader("Content-Type", "text/plain");
                        outTransport.setStatusCode(200);
                        OutputStreamWriter out = new OutputStreamWriter(outTransport.getOutgoingStream(), "UTF-8");
                        ((Writer)out).flush();
                    }
                    catch (Exception we) {
                        this.log.error("Error returning empty response.", (Throwable)we);
                    }
                } else {
                    this.localLogout(indexedSession, inTransport, outTransport, requestContext);
                }
                this.writeAuditLogEntry(requestContext);
                return;
            }
            if (status.getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
                this.log.info("Invalidating session identified by LogoutRequest: {}", (Object)indexedSession.getSessionID());
                this.destroySession(indexedSession);
                samlResponse = this.buildLogoutResponse(requestContext, status);
            } else {
                requestContext.setFailureStatus(status);
                samlResponse = this.buildLogoutResponse(requestContext, null);
            }
        }
        catch (ProfileException e) {
            if (requestContext.getPeerEntityEndpoint() != null) {
                if (requestContext.getFailureStatus() == null) {
                    requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, e.getMessage()));
                }
                samlResponse = this.buildLogoutResponse(requestContext, null);
            }
            if (!requestContext.isAsynchronous() && this.getInboundBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                this.log.debug("Returning SOAP fault", (Throwable)e);
                try {
                    outTransport.setCharacterEncoding("UTF-8");
                    outTransport.setHeader("Content-Type", "application/soap+xml");
                    outTransport.setStatusCode(500);
                    OutputStreamWriter out = new OutputStreamWriter(outTransport.getOutgoingStream(), "UTF-8");
                    out.write("<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"> <env:Body> <env:Fault> <faultcode>env:Client</faultcode> <faultstring>An error occurred processing the request.</faultstring> <detail/> </env:Fault> </env:Body></env:Envelope>");
                    ((Writer)out).flush();
                }
                catch (Exception we) {
                    this.log.error("Error returning SOAP fault", (Throwable)we);
                }
                return;
            }
            throw e;
        }
        requestContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        requestContext.setOutboundSAMLMessageId(samlResponse.getID());
        requestContext.setOutboundSAMLMessageIssueInstant(samlResponse.getIssueInstant());
        this.encodeResponse(requestContext);
        this.writeAuditLogEntry(requestContext);
    }

    protected LogoutResponse buildLogoutResponse(SLORequestContext requestContext, Status status) throws ProfileException {
        LogoutResponse logoutResponse = (LogoutResponse)this.responseBuilder.buildObject();
        logoutResponse.setIssueInstant(new DateTime());
        this.populateStatusResponse(requestContext, (StatusResponseType)logoutResponse);
        if (status != null) {
            logoutResponse.setStatus(status);
        } else {
            logoutResponse.setStatus(requestContext.getFailureStatus());
        }
        return logoutResponse;
    }

    protected void destroySession(Session session) {
        this.getSessionManager().destroySession(session.getSessionID());
    }

    @Override
    protected void populateSAMLMessageInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        if (requestContext.getInboundSAMLMessage() instanceof LogoutRequest) {
            LogoutRequest request = (LogoutRequest)requestContext.getInboundSAMLMessage();
            requestContext.setPeerEntityId(request.getIssuer().getValue());
            requestContext.setInboundSAMLMessageId(request.getID());
            if (request.getNameID() != null) {
                requestContext.setSubjectNameIdentifier((SAMLObject)request.getNameID());
            } else {
                if (request.getEncryptedID() != null) {
                    throw new ProfileException("Use of EncryptedID not supported in LogoutRequest.");
                }
                throw new ProfileException("Incoming LogoutRequest did not contain SAML2 NameID.");
            }
        }
    }

    @Override
    protected void populateRelyingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateRelyingPartyInformation(requestContext);
        EntityDescriptor relyingPartyMetadata = requestContext.getPeerEntityMetadata();
        if (relyingPartyMetadata != null) {
            requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setPeerEntityRoleMetadata((RoleDescriptor)relyingPartyMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    @Override
    protected void populateAssertingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateAssertingPartyInformation(requestContext);
        EntityDescriptor localEntityDescriptor = requestContext.getLocalEntityMetadata();
        if (localEntityDescriptor != null) {
            requestContext.setLocalEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setLocalEntityRoleMetadata((RoleDescriptor)localEntityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    @Override
    protected Endpoint selectEndpoint(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        Endpoint endpoint = null;
        if (this.getInboundBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            endpoint = (Endpoint)this.sloServiceBuilder.buildObject();
            endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        } else {
            BasicEndpointSelector endpointSelector = new BasicEndpointSelector();
            endpointSelector.setEndpointType(SingleLogoutService.DEFAULT_ELEMENT_NAME);
            endpointSelector.setMetadataProvider(this.getMetadataProvider());
            endpointSelector.setEntityMetadata(requestContext.getPeerEntityMetadata());
            endpointSelector.setEntityRoleMetadata(requestContext.getPeerEntityRoleMetadata());
            endpointSelector.setSamlRequest(requestContext.getInboundSAMLMessage());
            endpointSelector.getSupportedIssuerBindings().addAll(this.getSupportedOutboundBindings());
            endpoint = endpointSelector.selectEndpoint();
        }
        return endpoint;
    }

    @Override
    protected void populateProfileInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        boolean async;
        AbstractSAMLProfileConfiguration profileConfig = (AbstractSAMLProfileConfiguration)requestContext.getRelyingPartyConfiguration().getProfileConfiguration(this.getProfileId());
        if (profileConfig != null) {
            requestContext.setProfileConfiguration((ProfileConfiguration)profileConfig);
            requestContext.setOutboundMessageArtifactType(profileConfig.getOutboundArtifactType());
        }
        if (!(async = ((SLORequestContext)requestContext).isAsynchronous())) {
            Endpoint endpoint = this.selectEndpoint(requestContext);
            if (endpoint == null) {
                this.log.warn("No return endpoint available for relying party {}, treating LogoutRequest as Asynchronous", (Object)requestContext.getInboundMessageIssuer());
                ((SLORequestContext)requestContext).setAsynchronous(true);
            }
            requestContext.setPeerEntityEndpoint(endpoint);
        } else {
            this.log.debug("No response requested, so skipping endpoint selection.");
        }
    }

    protected void decodeRequest(SLORequestContext requestContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        this.log.debug("Decoding message with decoder binding '{}'", (Object)this.getInboundBinding());
        requestContext.setCommunicationProfileId(this.getProfileId());
        requestContext.setMetadataProvider(this.getMetadataProvider());
        requestContext.setInboundMessageTransport((InTransport)inTransport);
        requestContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        requestContext.setSecurityPolicyResolver(this.getSecurityPolicyResolver());
        requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        requestContext.setOutboundMessageTransport((OutTransport)outTransport);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        try {
            SAMLMessageDecoder decoder = this.getInboundMessageDecoder(requestContext);
            requestContext.setMessageDecoder(decoder);
            decoder.decode((MessageContext)requestContext);
            this.log.debug("Decoded request from relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
            if (!(requestContext.getInboundSAMLMessage() instanceof LogoutRequest)) {
                this.log.warn("Incoming message was not a LogoutRequest, it was a {}", (Object)((LogoutRequest)requestContext.getInboundSAMLMessage()).getClass().getName());
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", null, "Invalid SAML LogoutRequest message."));
                throw new ProfileException("Invalid SAML LogoutRequest message.");
            }
            LogoutRequest logoutRequest = (LogoutRequest)requestContext.getInboundSAMLMessage();
            Extensions exts = logoutRequest.getExtensions();
            if (exts != null) {
                List asyncs = exts.getUnknownXMLObjects(Asynchronous.DEFAULT_ELEMENT_NAME);
                requestContext.setAsynchronous(asyncs != null && !asyncs.isEmpty());
                if (requestContext.isAsynchronous()) {
                    this.log.debug("Incoming LogoutRequest contains aslo:Asynchronous extension.");
                }
            }
        }
        catch (MessageDecodingException e) {
            String msg = "Error decoding logout request message";
            this.log.warn(msg, (Throwable)e);
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, msg));
            throw new ProfileException(msg, (Throwable)e);
        }
        catch (SecurityException e) {
            String msg = "Message did not meet security requirements";
            this.log.warn(msg, (Throwable)e);
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg));
            throw new ProfileException(msg, (Throwable)e);
        }
        finally {
            this.populateRequestContext(requestContext);
        }
    }

    public class SLORequestContext
    extends BaseSAML2ProfileRequestContext<LogoutRequest, LogoutResponse, LogoutRequestConfiguration> {
        private boolean async;

        public boolean isAsynchronous() {
            return this.async;
        }

        public void setAsynchronous(boolean flag) {
            this.async = flag;
        }
    }
}

