/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml2;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml2.SSOConfiguration;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.BaseSAML2ProfileRequestContext;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.SSOProfileHandler;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.xml.security.utils.Base64;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml2.binding.decoding.HTTPSOAP11Decoder;
import org.opensaml.saml2.binding.decoding.HandlerChainAwareHTTPSOAP11Decoder;
import org.opensaml.saml2.binding.encoding.HandlerChainAwareHTTPSOAP11Encoder;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.core.Advice;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Statement;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.ecp.RequestAuthenticated;
import org.opensaml.saml2.ecp.Response;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.samlext.saml2cb.ChannelBindings;
import org.opensaml.samlext.samlec.GeneratedKey;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.handler.BasicHandlerChain;
import org.opensaml.ws.message.handler.Handler;
import org.opensaml.ws.message.handler.HandlerChain;
import org.opensaml.ws.message.handler.HandlerChainResolver;
import org.opensaml.ws.message.handler.HandlerException;
import org.opensaml.ws.message.handler.StaticHandlerChainResolver;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.util.SOAPHelper;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ECPProfileHandler
extends SSOProfileHandler {
    private final Logger log = LoggerFactory.getLogger(SAML2ECPProfileHandler.class);
    private final SecureRandom prng = new SecureRandom();
    private String authnContextClassRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
    private SAMLObjectBuilder<Response> ecpResponseBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Response.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<RequestAuthenticated> reqAuthnBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(RequestAuthenticated.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<ChannelBindings> cbBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ChannelBindings.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<GeneratedKey> keyBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(GeneratedKey.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Advice> adviceBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Advice.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<AuthnContext> authnContextBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<AuthnContextClassRef> authnContextClassRefBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
    private StaticHandlerChainResolver inboundPreSecurityHandlerChainResolver;
    private StaticHandlerChainResolver inboundPostSecurityHandlerChainResolver;
    private StaticHandlerChainResolver outboundHandlerChainResolver;
    private SAMLMessageEncoder messageEncoder;
    private SAMLMessageDecoder messageDecoder;
    private final String soapFaultResponseMessage = "<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"> <env:Body> <env:Fault> <faultcode>env:Client</faultcode> <faultstring>An error occurred processing the request.</faultstring> <detail/> </env:Fault> </env:Body></env:Envelope>";

    public SAML2ECPProfileHandler() {
        super("/Save/My/Walrus");
    }

    public void initialize() {
        this.messageDecoder = new HandlerChainAwareHTTPSOAP11Decoder();
        ((HTTPSOAP11Decoder)this.messageDecoder).getUnderstoodHeaders().add(ChannelBindings.DEFAULT_ELEMENT_NAME);
        this.messageEncoder = new HandlerChainAwareHTTPSOAP11Encoder();
        ((HandlerChainAwareHTTPSOAP11Encoder)this.messageEncoder).setNotConfidential(true);
        this.inboundPreSecurityHandlerChainResolver = new StaticHandlerChainResolver(this.buildPreSecurityInboundHandlerChain());
        this.inboundPostSecurityHandlerChainResolver = new StaticHandlerChainResolver(this.buildPostSecurityInboundHandlerChain());
        this.outboundHandlerChainResolver = new StaticHandlerChainResolver(this.buildOutboundHandlerChain());
        ArrayList<String> ecpOutboundBindings = new ArrayList<String>();
        ecpOutboundBindings.add("urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
        this.setSupportedOutboundBindings(ecpOutboundBindings);
    }

    @Override
    public String getProfileId() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp";
    }

    public void setAuthnContextClassRef(String ref) {
        this.authnContextClassRef = ref;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    @Override
    public void processRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        org.opensaml.saml2.core.Response samlResponse;
        ECPRequestContext requestContext = this.buildRequestContext(inTransport, outTransport);
        try {
            AttributeStatement attributeStatement;
            String relyingPartyId;
            RelyingPartyConfiguration rpConfig;
            ProfileConfiguration ecpConfig;
            this.decodeRequest(requestContext, inTransport, outTransport);
            this.checkSamlVersion(requestContext);
            this.checkNameIDPolicy(requestContext);
            if (requestContext.getPrincipalName() == null) {
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", null));
                throw new ProfileException("Authentication not performed");
            }
            this.checkChannelBindings(requestContext);
            if (requestContext.getSubjectNameIdentifier() != null) {
                this.log.debug("Request contained a subject with a name identifier, resolving principal from NameID");
                String authenticatedName = requestContext.getPrincipalName();
                this.resolvePrincipal(requestContext);
                String requestedPrincipalName = requestContext.getPrincipalName();
                if (!DatatypeHelper.safeEquals((Object)authenticatedName, (Object)requestedPrincipalName)) {
                    this.log.warn("Request identified principal {} but authentication mechanism identified principal {}", (Object)requestedPrincipalName, (Object)authenticatedName);
                    requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", null));
                    throw new ProfileException("User failed authentication");
                }
            }
            if ((ecpConfig = (rpConfig = this.getRelyingPartyConfiguration(relyingPartyId = requestContext.getInboundMessageIssuer())).getProfileConfiguration(this.getProfileId())) == null) {
                this.log.warn("SAML2ECP profile is not configured for relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", null));
                throw new ProfileException("SAML2ECP profile is not configured for relying party");
            }
            this.resolveAttributes(requestContext);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add((Statement)this.buildAuthnStatement(requestContext));
            if (((SSOConfiguration)requestContext.getProfileConfiguration()).includeAttributeStatement() && (attributeStatement = this.buildAttributeStatement(requestContext)) != null) {
                requestContext.setReleasedAttributes(requestContext.getAttributes().keySet());
                statements.add((Statement)attributeStatement);
            }
            samlResponse = this.buildResponse(requestContext, "urn:oasis:names:tc:SAML:2.0:cm:bearer", statements);
            samlResponse.setDestination(requestContext.getPeerEntityEndpoint().getLocation());
        }
        catch (ProfileException e) {
            if (requestContext.getPeerEntityEndpoint() != null) {
                samlResponse = this.buildErrorResponse(requestContext);
            }
            this.log.debug("Returning SOAP fault", (Throwable)e);
            try {
                outTransport.setCharacterEncoding("UTF-8");
                outTransport.setHeader("Content-Type", "application/soap+xml");
                outTransport.setStatusCode(500);
                OutputStreamWriter out = new OutputStreamWriter(outTransport.getOutgoingStream(), "UTF-8");
                out.write("<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"> <env:Body> <env:Fault> <faultcode>env:Client</faultcode> <faultstring>An error occurred processing the request.</faultstring> <detail/> </env:Fault> </env:Body></env:Envelope>");
                ((Writer)out).flush();
            }
            catch (Exception we) {
                this.log.error("Error returning SOAP fault", (Throwable)we);
            }
            return;
        }
        requestContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        requestContext.setOutboundSAMLMessageId(samlResponse.getID());
        requestContext.setOutboundSAMLMessageIssueInstant(samlResponse.getIssueInstant());
        this.encodeResponse(requestContext);
        this.writeAuditLogEntry(requestContext);
    }

    protected void decodeRequest(ECPRequestContext requestContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Decoding message with decoder binding '{}'", (Object)this.getInboundMessageDecoder(requestContext).getBindingURI());
        }
        try {
            Extensions exts;
            SAMLMessageDecoder decoder = this.getInboundMessageDecoder(requestContext);
            requestContext.setMessageDecoder(decoder);
            decoder.decode((MessageContext)requestContext);
            this.log.debug("Decoded request from relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
            if (!(requestContext.getInboundSAMLMessage() instanceof AuthnRequest)) {
                this.log.warn("Incomming message was not a AuthnRequest, it was a '{}'", (Object)((AuthnRequest)requestContext.getInboundSAMLMessage()).getClass().getName());
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "Invalid SAML AuthnRequest message."));
                throw new ProfileException("Invalid SAML AuthnRequest message.");
            }
            AuthnRequest authnRequest = (AuthnRequest)requestContext.getInboundSAMLMessage();
            Subject authnSubject = authnRequest.getSubject();
            if (authnSubject != null) {
                requestContext.setSubjectNameIdentifier((SAMLObject)authnSubject.getNameID());
            }
            if ((exts = authnRequest.getExtensions()) != null) {
                List cbs = exts.getUnknownXMLObjects(ChannelBindings.DEFAULT_ELEMENT_NAME);
                for (XMLObject cb : cbs) {
                    requestContext.getSPChannelBindings().add((ChannelBindings)cb);
                }
            }
        }
        catch (MessageDecodingException e) {
            String msg = "Error decoding authentication request message";
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", msg));
            this.log.warn(msg, (Throwable)e);
            throw new ProfileException(msg, (Throwable)e);
        }
        catch (SecurityException e) {
            String msg = "Message did not meet security requirements";
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg));
            this.log.warn(msg, (Throwable)e);
            throw new ProfileException(msg, (Throwable)e);
        }
        this.populateRequestContext(requestContext);
    }

    protected ECPRequestContext buildRequestContext(HTTPInTransport in, HTTPOutTransport out) throws ProfileException {
        ECPRequestContext requestContext = new ECPRequestContext();
        requestContext.setCommunicationProfileId(this.getProfileId());
        requestContext.setMessageDecoder(this.getInboundMessageDecoder(requestContext));
        requestContext.setInboundMessageTransport((InTransport)in);
        requestContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        requestContext.setOutboundMessageTransport((OutTransport)out);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        requestContext.setMetadataProvider(this.getMetadataProvider());
        requestContext.setSecurityPolicyResolver(this.getSecurityPolicyResolver());
        String relyingPartyId = requestContext.getInboundMessageIssuer();
        requestContext.setPeerEntityId(relyingPartyId);
        requestContext.setInboundMessageIssuer(relyingPartyId);
        requestContext.setPreSecurityInboundHandlerChainResolver(this.getPreSecurityInboundHandlerChainResolver());
        requestContext.setPostSecurityInboundHandlerChainResolver(this.getPostSecurityInboundHandlerChainResolver());
        requestContext.setOutboundHandlerChainResolver(this.getOutboundHandlerChainResolver());
        return requestContext;
    }

    protected void checkChannelBindings(ECPRequestContext requestContext) throws ProfileException {
        if (requestContext.getSPChannelBindings().isEmpty() && requestContext.getClientChannelBindings().isEmpty()) {
            return;
        }
        if (!requestContext.isInboundSAMLMessageAuthenticated()) {
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", null, "Channel bindings verification failed, request was unauthenticated"));
            throw new ProfileException("Channel bindings verification failed, request was unauthenticated");
        }
        this.log.debug("Attempting to match channel bindings supplied by SP and client");
        for (ChannelBindings clientCB : requestContext.getClientChannelBindings()) {
            for (ChannelBindings spCB : requestContext.getSPChannelBindings()) {
                if (!DatatypeHelper.safeEquals((Object)clientCB.getType(), (Object)spCB.getType()) || clientCB.getValue() == null || spCB.getValue() == null || !clientCB.getValue().equals(spCB.getValue())) continue;
                requestContext.setMatchedChannelBindings(clientCB);
                this.log.debug("Channel bindings of type {} matched", (Object)clientCB.getType());
                return;
            }
        }
        requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", null, "Channel bindings verification failed, no match found"));
        throw new ProfileException("Channel bindings verification failed, no match found");
    }

    @Override
    protected void populateSAMLMessageInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        AuthnRequest authnRequest = (AuthnRequest)requestContext.getInboundSAMLMessage();
        Subject authnSubject = authnRequest.getSubject();
        if (authnSubject != null) {
            requestContext.setSubjectNameIdentifier((SAMLObject)authnSubject.getNameID());
        }
    }

    @Override
    protected AuthnStatement buildAuthnStatement(SSOProfileHandler.SSORequestContext requestContext) {
        AuthnStatement statement = super.buildAuthnStatement(requestContext);
        statement.setAuthnInstant(new DateTime());
        return statement;
    }

    @Override
    protected AuthnContext buildAuthnContext(SSOProfileHandler.SSORequestContext requestContext) {
        if (this.getAuthnContextClassRef() != null) {
            AuthnContext authnContext = (AuthnContext)this.authnContextBuilder.buildObject();
            AuthnContextClassRef ref = (AuthnContextClassRef)this.authnContextClassRefBuilder.buildObject();
            ref.setAuthnContextClassRef(this.getAuthnContextClassRef());
            authnContext.setAuthnContextClassRef(ref);
            return authnContext;
        }
        return null;
    }

    @Override
    protected void postProcessAssertion(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, Assertion assertion) throws ProfileException {
        ChannelBindings cb;
        super.postProcessAssertion(requestContext, assertion);
        Advice advice = assertion.getAdvice();
        if (advice == null) {
            advice = (Advice)this.adviceBuilder.buildObject();
            assertion.setAdvice(advice);
        }
        if ((cb = ((ECPRequestContext)requestContext).getMatchedChannelBindings()) != null) {
            ChannelBindings cbOut = (ChannelBindings)this.cbBuilder.buildObject();
            if (cb.getType() != null) {
                cbOut.setType(cb.getType());
            }
            advice.getChildren().add(cbOut);
        }
        GeneratedKey key = (GeneratedKey)this.keyBuilder.buildObject();
        key.setValue(((ECPRequestContext)requestContext).getGeneratedKey());
        advice.getChildren().add(key);
    }

    protected HandlerChain buildPreSecurityInboundHandlerChain() {
        BasicHandlerChain handlerChain = new BasicHandlerChain();
        handlerChain.getHandlers().add(new Handler(){

            public void invoke(MessageContext msgContext) throws HandlerException {
                ECPRequestContext ctx = (ECPRequestContext)msgContext;
                HttpServletRequest httpRequest = ((HttpServletRequestAdapter)msgContext.getInboundMessageTransport()).getWrappedRequest();
                String user = httpRequest.getRemoteUser();
                if (user != null) {
                    SAML2ECPProfileHandler.this.log.debug("Setting principal name: {}", (Object)user);
                    ctx.setPrincipalName(user);
                } else {
                    SAML2ECPProfileHandler.this.log.warn("REMOTE_USER not set, unable to set principal name");
                }
            }
        });
        return handlerChain;
    }

    protected HandlerChain buildPostSecurityInboundHandlerChain() {
        BasicHandlerChain handlerChain = new BasicHandlerChain();
        handlerChain.getHandlers().add(new Handler(){

            public void invoke(MessageContext msgContext) throws HandlerException {
                ECPRequestContext ctx = (ECPRequestContext)msgContext;
                if (msgContext.getInboundMessage() instanceof Envelope) {
                    Envelope env = (Envelope)msgContext.getInboundMessage();
                    if (env.getHeader() != null) {
                        List cbList = env.getHeader().getUnknownXMLObjects(ChannelBindings.DEFAULT_ELEMENT_NAME);
                        for (XMLObject cb : cbList) {
                            String actor = SOAPHelper.getSOAP11ActorAttribute((XMLObject)cb);
                            if (actor == null || !"http://schemas.xmlsoap.org/soap/actor/next".equals(actor)) continue;
                            ctx.getClientChannelBindings().add((ChannelBindings)cb);
                        }
                    }
                } else {
                    throw new HandlerException("Inbound message not a SOAP envelope");
                }
            }
        });
        return handlerChain;
    }

    protected HandlerChainResolver getPreSecurityInboundHandlerChainResolver() {
        return this.inboundPreSecurityHandlerChainResolver;
    }

    protected HandlerChainResolver getPostSecurityInboundHandlerChainResolver() {
        return this.inboundPostSecurityHandlerChainResolver;
    }

    protected HandlerChain buildOutboundHandlerChain() {
        BasicHandlerChain handlerChain = new BasicHandlerChain();
        handlerChain.getHandlers().add(new Handler(){

            public void invoke(MessageContext msgContext) throws HandlerException {
                ChannelBindings cb;
                SAMLMessageContext samlMsgCtx = (SAMLMessageContext)msgContext;
                Response response = (Response)SAML2ECPProfileHandler.this.ecpResponseBuilder.buildObject();
                if (samlMsgCtx.getPeerEntityEndpoint() == null || samlMsgCtx.getPeerEntityEndpoint().getLocation() == null) {
                    throw new HandlerException("Unable to determine ACS URL for response.");
                }
                response.setAssertionConsumerServiceURL(samlMsgCtx.getPeerEntityEndpoint().getLocation());
                SOAPHelper.addSOAP11MustUnderstandAttribute((XMLObject)response, (boolean)true);
                SOAPHelper.addSOAP11ActorAttribute((XMLObject)response, (String)"http://schemas.xmlsoap.org/soap/actor/next");
                SOAPHelper.addHeaderBlock((MessageContext)msgContext, (XMLObject)response);
                if (samlMsgCtx.isInboundSAMLMessageAuthenticated()) {
                    RequestAuthenticated ra = (RequestAuthenticated)SAML2ECPProfileHandler.this.reqAuthnBuilder.buildObject();
                    SOAPHelper.addSOAP11ActorAttribute((XMLObject)response, (String)"http://schemas.xmlsoap.org/soap/actor/next");
                    SOAPHelper.addHeaderBlock((MessageContext)msgContext, (XMLObject)ra);
                }
                if ((cb = ((ECPRequestContext)msgContext).getMatchedChannelBindings()) != null) {
                    ChannelBindings cbOut = (ChannelBindings)SAML2ECPProfileHandler.this.cbBuilder.buildObject();
                    if (cb.getType() != null) {
                        cbOut.setType(cb.getType());
                    }
                    SOAPHelper.addSOAP11MustUnderstandAttribute((XMLObject)cbOut, (boolean)true);
                    SOAPHelper.addSOAP11ActorAttribute((XMLObject)cbOut, (String)"http://schemas.xmlsoap.org/soap/actor/next");
                    SOAPHelper.addHeaderBlock((MessageContext)msgContext, (XMLObject)cbOut);
                }
                GeneratedKey key = (GeneratedKey)SAML2ECPProfileHandler.this.keyBuilder.buildObject();
                key.setValue(((ECPRequestContext)msgContext).getGeneratedKey());
                SOAPHelper.addSOAP11ActorAttribute((XMLObject)key, (String)"http://schemas.xmlsoap.org/soap/actor/next");
                SOAPHelper.addHeaderBlock((MessageContext)msgContext, (XMLObject)key);
            }
        });
        return handlerChain;
    }

    protected HandlerChainResolver getOutboundHandlerChainResolver() {
        return this.outboundHandlerChainResolver;
    }

    @Override
    protected SAMLMessageEncoder getOutboundMessageEncoder(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        return this.messageEncoder;
    }

    @Override
    protected SAMLMessageDecoder getInboundMessageDecoder(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        return this.messageDecoder;
    }

    protected class ECPRequestContext
    extends SSOProfileHandler.SSORequestContext {
        private List<ChannelBindings> spChannelBindings;
        private List<ChannelBindings> clientChannelBindings;
        private ChannelBindings matchedChannelBindings;
        private final String generatedKey;

        public ECPRequestContext() {
            super(SAML2ECPProfileHandler.this);
            this.spChannelBindings = new ArrayList<ChannelBindings>();
            this.clientChannelBindings = new ArrayList<ChannelBindings>();
            byte[] buf = new byte[32];
            SAML2ECPProfileHandler.this.prng.nextBytes(buf);
            this.generatedKey = Base64.encode((byte[])buf);
        }

        public List<ChannelBindings> getSPChannelBindings() {
            return this.spChannelBindings;
        }

        public List<ChannelBindings> getClientChannelBindings() {
            return this.clientChannelBindings;
        }

        public ChannelBindings getMatchedChannelBindings() {
            return this.matchedChannelBindings;
        }

        public void setMatchedChannelBindings(ChannelBindings cb) {
            this.matchedChannelBindings = cb;
        }

        public String getGeneratedKey() {
            return this.generatedKey;
        }
    }
}

