/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml2;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml2.AttributeQueryConfiguration;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.AbstractSAML2ProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.BaseSAML2ProfileRequestContext;
import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import java.util.ArrayList;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Statement;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeQueryProfileHandler
extends AbstractSAML2ProfileHandler {
    private static Logger log = LoggerFactory.getLogger(AttributeQueryProfileHandler.class);
    private SAMLObjectBuilder<NameID> nameIDBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<AssertionConsumerService> acsEndpointBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);

    public String getProfileId() {
        return "urn:mace:shibboleth:2.0:profiles:saml2:query:attribute";
    }

    public void processRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        Response samlResponse;
        AttributeQueryContext requestContext = new AttributeQueryContext();
        try {
            this.decodeRequest(requestContext, inTransport, outTransport);
            if (requestContext.getProfileConfiguration() == null) {
                String msg = "SAML 2 Attribute Query profile is not configured for relying party " + requestContext.getInboundMessage();
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg));
                log.warn(msg);
                samlResponse = this.buildErrorResponse(requestContext);
            } else {
                this.checkSamlVersion(requestContext);
                AttributeQuery query = (AttributeQuery)requestContext.getInboundSAMLMessage();
                if (query.getAttributes() != null) {
                    for (Attribute desig : query.getAttributes()) {
                        if (desig.getAttributeValues() == null || desig.getAttributeValues().isEmpty()) continue;
                        log.warn("Specific attribute values requested in query from '{}'. This functionality is not supported", (Object)requestContext.getInboundMessageIssuer());
                        requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "Request of specific attribute values during an attribute query is not supported"));
                        throw new ProfileException();
                    }
                }
                this.resolvePrincipal(requestContext);
                Session idpSession = (Session)this.getSessionManager().getSession(requestContext.getPrincipalName());
                if (idpSession != null) {
                    requestContext.setUserSession(idpSession);
                    AuthenticationMethodInformation authnInfo = idpSession.getAuthenticationMethods().get(requestContext.getInboundMessageIssuer());
                    if (authnInfo != null) {
                        requestContext.setPrincipalAuthenticationMethod(authnInfo.getAuthenticationMethod());
                    }
                }
                this.resolveAttributes(requestContext);
                ArrayList<Statement> statements = new ArrayList<Statement>();
                AttributeStatement attributeStatement = this.buildAttributeStatement(requestContext);
                if (attributeStatement != null) {
                    requestContext.setReleasedAttributes(requestContext.getAttributes().keySet());
                    statements.add((Statement)attributeStatement);
                }
                samlResponse = this.buildResponse(requestContext, "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches", statements);
            }
        }
        catch (ProfileException e) {
            samlResponse = this.buildErrorResponse(requestContext);
        }
        requestContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        requestContext.setOutboundSAMLMessageId(samlResponse.getID());
        requestContext.setOutboundSAMLMessageIssueInstant(samlResponse.getIssueInstant());
        this.encodeResponse(requestContext);
        this.writeAuditLogEntry(requestContext);
    }

    protected void decodeRequest(AttributeQueryContext requestContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        if (log.isDebugEnabled()) {
            log.debug("Decoding message with decoder binding '{}'", (Object)this.getInboundMessageDecoder(requestContext).getBindingURI());
        }
        requestContext.setCommunicationProfileId(this.getProfileId());
        MetadataProvider metadataProvider = this.getMetadataProvider();
        requestContext.setMetadataProvider(metadataProvider);
        requestContext.setInboundMessageTransport((InTransport)inTransport);
        requestContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        requestContext.setSecurityPolicyResolver(this.getSecurityPolicyResolver());
        requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        requestContext.setOutboundMessageTransport((OutTransport)outTransport);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        try {
            SAMLMessageDecoder decoder = this.getInboundMessageDecoder(requestContext);
            requestContext.setMessageDecoder(decoder);
            decoder.decode((MessageContext)requestContext);
            log.debug("Decoded request from relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
            if (!(requestContext.getInboundSAMLMessage() instanceof AttributeQuery)) {
                log.warn("Incoming message was not a AttributeQuery, it was a {}", (Object)((AttributeQuery)requestContext.getInboundSAMLMessage()).getClass().getName());
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", null, "Invalid SAML AttributeQuery message."));
                throw new ProfileException("Invalid SAML AttributeQuery message.");
            }
        }
        catch (MessageDecodingException e) {
            String msg = "Error decoding attribute query message";
            log.warn(msg, (Throwable)e);
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, msg));
            throw new ProfileException(msg);
        }
        catch (SecurityException e) {
            String msg = "Message did not meet security requirements";
            log.warn(msg, (Throwable)e);
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg));
            throw new ProfileException(msg, (Throwable)e);
        }
        finally {
            this.populateRequestContext(requestContext);
        }
    }

    @Override
    protected void populateRelyingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateRelyingPartyInformation(requestContext);
        EntityDescriptor relyingPartyMetadata = requestContext.getPeerEntityMetadata();
        if (relyingPartyMetadata != null) {
            requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setPeerEntityRoleMetadata((RoleDescriptor)relyingPartyMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    @Override
    protected void populateAssertingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateAssertingPartyInformation(requestContext);
        EntityDescriptor localEntityDescriptor = requestContext.getLocalEntityMetadata();
        if (localEntityDescriptor != null) {
            requestContext.setLocalEntityRole(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setLocalEntityRoleMetadata((RoleDescriptor)localEntityDescriptor.getAttributeAuthorityDescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    @Override
    protected void populateSAMLMessageInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        AttributeQuery query = (AttributeQuery)requestContext.getInboundSAMLMessage();
        if (query != null) {
            Subject subject = query.getSubject();
            if (subject == null) {
                String msg = "Attribute query did not contain a proper subject";
                log.warn(msg);
                ((AttributeQueryContext)requestContext).setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", null, msg));
                throw new ProfileException(msg);
            }
            requestContext.setSubjectNameIdentifier((SAMLObject)subject.getNameID());
        }
    }

    @Override
    protected Endpoint selectEndpoint(BaseSAMLProfileRequestContext requestContext) {
        Endpoint endpoint;
        if (this.getInboundBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            endpoint = (Endpoint)this.acsEndpointBuilder.buildObject();
            endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        } else {
            BasicEndpointSelector endpointSelector = new BasicEndpointSelector();
            endpointSelector.setEndpointType(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
            endpointSelector.setMetadataProvider(this.getMetadataProvider());
            endpointSelector.setEntityMetadata(requestContext.getPeerEntityMetadata());
            endpointSelector.setEntityRoleMetadata(requestContext.getPeerEntityRoleMetadata());
            endpointSelector.setSamlRequest(requestContext.getInboundSAMLMessage());
            endpointSelector.getSupportedIssuerBindings().addAll(this.getSupportedOutboundBindings());
            endpoint = endpointSelector.selectEndpoint();
        }
        return endpoint;
    }

    @Override
    protected NameID buildNameId(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        log.debug("Reusing NameID supplied in query");
        NameID src = (NameID)requestContext.getSubjectNameIdentifier();
        if (src != null) {
            NameID dest = (NameID)this.nameIDBuilder.buildObject();
            dest.setValue(src.getValue());
            dest.setNameQualifier(src.getNameQualifier());
            dest.setSPNameQualifier(src.getSPNameQualifier());
            dest.setFormat(src.getFormat());
            dest.setSPProvidedID(src.getSPProvidedID());
            if (dest.getValue() != null) {
                BasicAttribute attribute = new BasicAttribute();
                attribute.setId("outboundQueryNameID");
                attribute.getValues().add(dest.getValue());
                requestContext.setNameIdentifierAttribute((BaseAttribute)attribute);
            }
            return dest;
        }
        return null;
    }

    protected class AttributeQueryContext
    extends BaseSAML2ProfileRequestContext<AttributeQuery, Response, AttributeQueryConfiguration> {
        protected AttributeQueryContext() {
        }
    }
}

