/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn;

import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Saml2LoginContext
extends LoginContext
implements Serializable {
    private static final long serialVersionUID = -7117092606828289070L;
    private String relayState;
    private transient AuthnRequest authnRequest;
    private String serialAuthnRequest;
    private boolean requestAuthenticated;
    private boolean unsolicited;

    public Saml2LoginContext(String relyingParty, String state, AuthnRequest request) throws MarshallingException {
        if (relyingParty == null || request == null) {
            throw new IllegalArgumentException("SAML 2 authentication request and relying party ID may not be null");
        }
        this.setRelyingParty(relyingParty);
        this.relayState = state;
        this.authnRequest = request;
        this.serialAuthnRequest = this.serializeRequest(request);
        this.setForceAuthRequired(request.isForceAuthn());
        this.setPassiveAuthRequired(request.isPassive());
        this.getRequestedAuthenticationMethods().addAll(this.extractRequestedAuthenticationMethods(request));
    }

    public synchronized AuthnRequest getAuthenticiationRequestXmlObject() throws UnmarshallingException {
        if (this.authnRequest == null) {
            try {
                ParserPool parser = Configuration.getParserPool();
                Document requestDoc = parser.parse((Reader)new StringReader(this.serialAuthnRequest));
                Unmarshaller requestUnmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(AuthnRequest.TYPE_NAME);
                this.authnRequest = (AuthnRequest)requestUnmarshaller.unmarshall(requestDoc.getDocumentElement());
            }
            catch (XMLParserException e) {
                throw new UnmarshallingException("Unable to unmarshall serialized authentication request", (Exception)((Object)e));
            }
        }
        return this.authnRequest;
    }

    public String getAuthenticationRequest() throws UnmarshallingException {
        return this.serialAuthnRequest;
    }

    public synchronized String getRelayState() {
        return this.relayState;
    }

    public boolean isUnsolicited() {
        return this.unsolicited;
    }

    public void setUnsolicited(boolean isUnsolicited) {
        this.unsolicited = isUnsolicited;
    }

    public boolean isRequestAuthenticated() {
        return this.requestAuthenticated;
    }

    public void setRequestAuthenticated(boolean flag) {
        this.requestAuthenticated = flag;
    }

    protected String serializeRequest(AuthnRequest request) throws MarshallingException {
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)request);
        Element requestElem = marshaller.marshall((XMLObject)request);
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode((Node)requestElem, (Writer)writer);
        return writer.toString();
    }

    protected List<String> extractRequestedAuthenticationMethods(AuthnRequest request) {
        List authnDeclRefs;
        LazyList requestedMethods = new LazyList();
        RequestedAuthnContext authnContext = request.getRequestedAuthnContext();
        if (authnContext == null) {
            return requestedMethods;
        }
        AuthnContextComparisonTypeEnumeration comparator = authnContext.getComparison();
        if (comparator != null && comparator != AuthnContextComparisonTypeEnumeration.EXACT) {
            Logger log = LoggerFactory.getLogger(Saml2LoginContext.class);
            log.warn("Unsupported comparision operator ( " + comparator + ") in RequestedAuthnContext. Only exact comparisions are supported.");
            return requestedMethods;
        }
        List authnClasses = authnContext.getAuthnContextClassRefs();
        if (authnClasses != null) {
            for (AuthnContextClassRef classRef : authnClasses) {
                if (classRef == null || DatatypeHelper.isEmpty((String)classRef.getAuthnContextClassRef())) continue;
                requestedMethods.add((Object)classRef.getAuthnContextClassRef());
            }
        }
        if ((authnDeclRefs = authnContext.getAuthnContextDeclRefs()) != null) {
            for (AuthnContextDeclRef declRef : authnDeclRefs) {
                if (declRef == null || DatatypeHelper.isEmpty((String)declRef.getAuthnContextDeclRef())) continue;
                requestedMethods.add((Object)declRef.getAuthnContextDeclRef());
            }
        }
        if (requestedMethods.contains((Object)"urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified")) {
            requestedMethods.clear();
        }
        return requestedMethods;
    }
}

