/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.system.conf1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import edu.internet2.middleware.shibboleth.common.profile.provider.AbstractShibbolethProfileHandler;
import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.ShibbolethSSOLoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.UsernamePrincipal;
import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import edu.internet2.middleware.shibboleth.idp.session.impl.AuthenticationMethodInformationImpl;
import edu.internet2.middleware.shibboleth.idp.system.conf1.BaseConf1TestCase;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.util.storage.StorageService;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;

public class ShibbolethSSOTestCase
extends BaseConf1TestCase {
    public void testFirstAuthenticationLeg() throws Exception {
        MockServletContext servletContext = new MockServletContext();
        MockHttpServletRequest servletRequest = this.buildServletRequest();
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        AbstractShibbolethProfileHandler handler = (AbstractShibbolethProfileHandler)handlerManager.getProfileHandler((ServletRequest)servletRequest);
        ShibbolethSSOTestCase.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        servletRequest.setCookies(servletResponse.getCookies());
        ShibbolethSSOLoginContext loginContext = (ShibbolethSSOLoginContext)HttpServletHelper.getLoginContext((StorageService)handler.getStorageService(), (ServletContext)servletContext, (HttpServletRequest)servletRequest);
        ShibbolethSSOTestCase.assertNotNull((Object)loginContext);
        ShibbolethSSOTestCase.assertEquals((boolean)false, (boolean)loginContext.getAuthenticationAttempted());
        ShibbolethSSOTestCase.assertEquals((boolean)false, (boolean)loginContext.isForceAuthRequired());
        ShibbolethSSOTestCase.assertEquals((boolean)false, (boolean)loginContext.isPassiveAuthRequired());
        ShibbolethSSOTestCase.assertEquals((String)"/AuthnEngine", (String)loginContext.getAuthenticationEngineURL());
        ShibbolethSSOTestCase.assertEquals((String)"/shibboleth/SSO", (String)loginContext.getProfileHandlerURL());
        ShibbolethSSOTestCase.assertEquals((String)"urn:example.org:sp1", (String)loginContext.getRelyingPartyId());
        ShibbolethSSOTestCase.assertEquals((int)0, (int)loginContext.getRequestedAuthenticationMethods().size());
        ShibbolethSSOTestCase.assertEquals((String)"https://example.org/mySP", (String)loginContext.getSpAssertionConsumerService());
        ShibbolethSSOTestCase.assertEquals((String)"https://example.org/mySP", (String)loginContext.getSpAssertionConsumerService());
        ShibbolethSSOTestCase.assertTrue((boolean)servletResponse.getRedirectedUrl().endsWith("/AuthnEngine"));
    }

    public void testSecondAuthenticationLeg() throws Exception {
        MockServletContext servletContext = new MockServletContext();
        MockHttpServletRequest servletRequest = this.buildServletRequest();
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        AbstractShibbolethProfileHandler handler = (AbstractShibbolethProfileHandler)handlerManager.getProfileHandler((ServletRequest)servletRequest);
        ShibbolethSSOTestCase.assertNotNull((Object)handler);
        HttpServletHelper.bindLoginContext((LoginContext)this.buildLoginContext(), (StorageService)handler.getStorageService(), (ServletContext)servletContext, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        servletRequest.setCookies(servletResponse.getCookies());
        SessionManager sessionManager = (SessionManager)this.getApplicationContext().getBean("shibboleth.SessionManager");
        Session idpSession = (Session)sessionManager.createSession();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal("foo"));
        idpSession.setSubject(subject);
        servletRequest.setAttribute("ShibbolethIdPSession", (Object)idpSession);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        ShibbolethSSOTestCase.assertTrue((boolean)response.contains("action=\"https&#x3a;&#x2f;&#x2f;example.org&#x2f;mySP\" method=\"post\""));
        ShibbolethSSOTestCase.assertTrue((boolean)response.contains("name=\"TARGET\" value=\"https&#x3a;&#x2f;&#x2f;example.org&#x2f;mySP\""));
        ShibbolethSSOTestCase.assertTrue((boolean)response.contains("SAMLResponse"));
    }

    public void testAuthenticationWithoutConfiguredSSO() {
        MockHttpServletRequest servletRequest = this.buildServletRequest();
        servletRequest.setParameter("providerId", "urn:example.org:BogusSP");
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        ShibbolethSSOTestCase.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        try {
            handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
            ShibbolethSSOTestCase.fail((String)"Request processing expected to due to lack of configured Shib SSO profile");
        }
        catch (ProfileException e) {
            // empty catch block
        }
    }

    protected MockHttpServletRequest buildServletRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setPathInfo("/shibboleth/SSO");
        request.setParameter("providerId", "urn:example.org:sp1");
        request.setParameter("shire", "https://example.org/mySP");
        request.setParameter("target", "https://example.org/mySP");
        return request;
    }

    protected ShibbolethSSOLoginContext buildLoginContext() {
        UsernamePrincipal principal = new UsernamePrincipal("test");
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)principal);
        AuthenticationMethodInformationImpl authnInfo = new AuthenticationMethodInformationImpl(subject, (Principal)principal, "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified", new DateTime(), 3600L);
        ShibbolethSSOLoginContext loginContext = new ShibbolethSSOLoginContext();
        loginContext.setAuthenticationMethodInformation((AuthenticationMethodInformation)authnInfo);
        loginContext.setPrincipalAuthenticated(true);
        loginContext.setRelyingParty("urn:example.org:sp1");
        loginContext.setSpAssertionConsumerService("https://example.org/mySP");
        loginContext.setSpTarget("https://example.org/mySP");
        return loginContext;
    }
}

