/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.system.conf1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import edu.internet2.middleware.shibboleth.idp.system.conf1.BaseConf1TestCase;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml1.core.AttributeQuery;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.Query;
import org.opensaml.saml1.core.Request;
import org.opensaml.saml1.core.Subject;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML1AttributeQueryTestCase
extends BaseConf1TestCase {
    public void testAttributeQuery() throws Exception {
        AttributeQuery query = this.buildAttributeQuery("urn:example.org:sp1");
        String soapMessage = this.getSOAPMessage(query);
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml1/SOAP/AttributeQuery");
        servletRequest.setContent(soapMessage.getBytes());
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML1AttributeQueryTestCase.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML1AttributeQueryTestCase.assertTrue((boolean)response.contains("saml1p:Success"));
        SAML1AttributeQueryTestCase.assertTrue((boolean)response.contains("AttributeName=\"urn:mace:dir:attribute-def:eduPersonEntitlement\""));
        SAML1AttributeQueryTestCase.assertTrue((boolean)response.contains("urn:example.org:entitlement:entitlement1"));
    }

    public void testAuthenticationWithoutConfiguredQuery() throws Exception {
        AttributeQuery query = this.buildAttributeQuery("urn:example.org:BogusSP");
        String soapMessage = this.getSOAPMessage(query);
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml1/SOAP/AttributeQuery");
        servletRequest.setContent(soapMessage.getBytes());
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML1AttributeQueryTestCase.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML1AttributeQueryTestCase.assertTrue((boolean)response.contains("saml1p:Responder"));
        SAML1AttributeQueryTestCase.assertTrue((boolean)response.contains("saml1p:RequestDenied"));
    }

    protected AttributeQuery buildAttributeQuery(String relyingPartyId) {
        SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameIdentifier.DEFAULT_ELEMENT_NAME);
        NameIdentifier nameId = (NameIdentifier)nameIdBuilder.buildObject();
        nameId.setNameIdentifier("testUser");
        nameId.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        subject.setNameIdentifier(nameId);
        SAMLObjectBuilder attributeQueryBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AttributeQuery.DEFAULT_ELEMENT_NAME);
        AttributeQuery query = (AttributeQuery)attributeQueryBuilder.buildObject();
        query.setResource(relyingPartyId);
        query.setSubject(subject);
        return query;
    }

    protected String getSOAPMessage(AttributeQuery query) throws MarshallingException {
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Request.DEFAULT_ELEMENT_NAME);
        Request request = (Request)requestBuilder.buildObject();
        request.setQuery((Query)query);
        request.setIssueInstant(new DateTime());
        request.setID("1");
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(request);
        SOAPObjectBuilder envelopeBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envelopeBuilder.buildObject();
        envelope.setBody(body);
        Marshaller marshaller = this.marshallerFactory.getMarshaller((XMLObject)envelope);
        Element envelopeElem = marshaller.marshall((XMLObject)envelope);
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode((Node)envelopeElem, (Writer)writer);
        return writer.toString();
    }
}

