/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.relyingparty;

import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfigurationManager;
import java.util.Collections;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;

public class RelyingPartySecurityPolicyResolver
implements SecurityPolicyResolver {
    private RelyingPartyConfigurationManager rpConfigManager;

    public RelyingPartySecurityPolicyResolver(RelyingPartyConfigurationManager configManager) {
        if (configManager == null) {
            throw new IllegalArgumentException("Relying party configuraiton manager may not be null");
        }
        this.rpConfigManager = configManager;
    }

    public Iterable<SecurityPolicy> resolve(MessageContext messageContext) throws SecurityException {
        return Collections.singletonList(this.resolveSingle(messageContext));
    }

    public SecurityPolicy resolveSingle(MessageContext messageContext) throws SecurityException {
        String peerEntityId = messageContext.getInboundMessageIssuer();
        if (DatatypeHelper.isEmpty((String)peerEntityId)) {
            throw new SecurityException("Unable to select security policy, ID of the peer unknown.");
        }
        RelyingPartyConfiguration rpConfig = this.rpConfigManager.getRelyingPartyConfiguration(peerEntityId);
        if (rpConfig == null) {
            return null;
        }
        String profileId = messageContext.getCommunicationProfileId();
        if (DatatypeHelper.isEmpty((String)profileId)) {
            throw new SecurityException("Unable to select security policy, communication profile ID unknown.");
        }
        ProfileConfiguration profileConfig = rpConfig.getProfileConfiguration(profileId);
        if (profileConfig == null) {
            return null;
        }
        return profileConfig.getSecurityPolicy();
    }
}

