/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import edu.internet2.middleware.shibboleth.common.config.security.AbstractCredentialBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.security.BasicCredentialFactoryBean;
import java.security.KeyException;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractBasicCredentialBeanDefinitionParser
extends AbstractCredentialBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(AbstractBasicCredentialBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return BasicCredentialFactoryBean.class;
    }

    @Override
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return element.getAttributeNS(null, "id");
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        this.log.info("Parsing configuration for {} credential with id: {}", (Object)XMLHelper.getXSIType((Element)element).getLocalPart(), (Object)element.getAttributeNS(null, "id"));
        this.parseAttributes(element, builder);
        Map configChildren = XMLHelper.getChildElements((Element)element);
        this.parseCommon(configChildren, builder);
        this.parseSecretKey(configChildren, builder);
        this.parsePrivateKey(configChildren, builder);
        this.parsePublicKey(configChildren, builder);
    }

    protected void parseSecretKey(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder) {
        List<Element> keyElems = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "SecretKey"));
        if (keyElems == null || keyElems.isEmpty()) {
            return;
        }
        this.log.debug("Parsing credential secret key");
        Element secretKeyElem = keyElems.get(0);
        byte[] encodedKey = this.getEncodedSecretKey(DatatypeHelper.safeTrimOrNullString((String)secretKeyElem.getTextContent()));
        String keyPassword = DatatypeHelper.safeTrimOrNullString((String)secretKeyElem.getAttributeNS(null, "password"));
        try {
            SecretKey key = SecurityHelper.decodeSecretKey((byte[])encodedKey, (char[])keyPassword.toCharArray());
            builder.addPropertyValue("secretKey", (Object)key);
        }
        catch (KeyException e) {
            throw new FatalBeanException("Unable to create credential, unable to parse secret key", (Throwable)e);
        }
    }

    protected abstract byte[] getEncodedSecretKey(String var1);

    protected void parsePublicKey(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder) {
        List<Element> keyElems = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "PublicKey"));
        if (keyElems == null || keyElems.isEmpty()) {
            return;
        }
        this.log.debug("Parsing credential public key");
        Element pubKeyElem = keyElems.get(0);
        byte[] encodedKey = this.getEncodedPublicKey(DatatypeHelper.safeTrimOrNullString((String)pubKeyElem.getTextContent()));
        String keyPassword = DatatypeHelper.safeTrimOrNullString((String)pubKeyElem.getAttributeNS(null, "password"));
        char[] keyPasswordCharArray = null;
        if (keyPassword != null) {
            keyPasswordCharArray = keyPassword.toCharArray();
        }
        try {
            PublicKey pubKey = SecurityHelper.decodePublicKey((byte[])Base64.decode((byte[])encodedKey, (int)0, (int)encodedKey.length), (char[])keyPasswordCharArray);
            builder.addPropertyValue("publicKey", (Object)pubKey);
        }
        catch (KeyException e) {
            throw new FatalBeanException("Unable to create credential, unable to parse public key", (Throwable)e);
        }
    }

    protected abstract byte[] getEncodedPublicKey(String var1);
}

