/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.saml;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML1AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML2AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSBase64Binary;
import org.opensaml.xml.schema.XSBoolean;
import org.opensaml.xml.schema.XSDateTime;
import org.opensaml.xml.schema.XSInteger;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.XSURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeInMetadataMatchFunctor
extends AbstractMatchFunctor {
    private final Logger log = LoggerFactory.getLogger(AttributeInMetadataMatchFunctor.class);
    private boolean onlyIfRequired;
    private boolean matchIfMetadataSilent;

    public boolean isOnlyIfRequired() {
        return this.onlyIfRequired;
    }

    public void setOnlyIfRequired(boolean flag) {
        this.onlyIfRequired = flag;
    }

    public boolean isMatchIfMetadataSilent() {
        return this.matchIfMetadataSilent;
    }

    public void setMatchIfMetadataSilent(boolean flag) {
        this.matchIfMetadataSilent = flag;
    }

    @Override
    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        throw new FilterProcessingException("This match functor is not supported in policy requirements");
    }

    @Override
    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String attributeId, Object attributeValue) throws FilterProcessingException {
        Integer i;
        RoleDescriptor role = filterContext.getAttributeRequestContext().getPeerEntityRoleMetadata();
        if (!(role instanceof SPSSODescriptor)) {
            this.log.debug("attribute requester's metadata role does not contain attribute requirements");
            return false;
        }
        AttributeConsumingService service = null;
        SAMLObject inbound = filterContext.getAttributeRequestContext().getInboundSAMLMessage();
        if (inbound != null && inbound instanceof AuthnRequest && (i = ((AuthnRequest)inbound).getAttributeConsumingServiceIndex()) != null) {
            List services = ((SPSSODescriptor)role).getAttributeConsumingServices();
            for (AttributeConsumingService s : services) {
                if (s.getIndex() != i.intValue()) continue;
                service = s;
                break;
            }
            if (service == null) {
                this.log.warn("Incoming AuthnRequest's AttributeConsumingServiceIndex did not match peer's metadata");
                return false;
            }
        }
        if (service == null) {
            service = ((SPSSODescriptor)role).getDefaultAttributeConsumingService();
        }
        if (service == null) {
            this.log.debug("The peer's metadata did not contain an AttributeConsumingService descriptor");
            return this.matchIfMetadataSilent;
        }
        this.log.debug("Using AttributeConsumingService descriptor with index {}", (Object)service.getIndex());
        BaseAttribute attr = filterContext.getUnfilteredAttributes().get(attributeId);
        if (attr != null && attr.getValues() != null) {
            List<AttributeEncoder> encoders = attr.getEncoders();
            for (AttributeEncoder encoder : encoders) {
                RequestedAttribute requested = this.findInMetadata(service, encoder);
                if (requested == null) continue;
                if (this.onlyIfRequired && !requested.isRequired().booleanValue()) {
                    this.log.debug("Attribute {} requested in metadata, but was not required", (Object)attributeId);
                    return false;
                }
                this.log.debug("Found attribute {} requested in metadata", (Object)attributeId);
                List vals = requested.getAttributeValues();
                if (vals == null || vals.isEmpty()) {
                    return true;
                }
                String v = attributeValue.toString();
                for (XMLObject xmlObj : vals) {
                    if (!this.match(xmlObj, v)) continue;
                    return true;
                }
                this.log.debug("Attribute {} found in metadata, but value not among those requested", (Object)attributeId);
                return false;
            }
            this.log.debug("Attribute {} not found in metadata", (Object)attributeId);
        }
        return false;
    }

    private RequestedAttribute findInMetadata(AttributeConsumingService service, AttributeEncoder encoder) {
        List requested = service.getRequestAttributes();
        for (RequestedAttribute attr : requested) {
            if (!attr.getName().equals(encoder.getAttributeName())) continue;
            String qualifier = null;
            if (encoder instanceof SAML2AttributeEncoder) {
                qualifier = ((SAML2AttributeEncoder)encoder).getNameFormat();
            } else if (encoder instanceof SAML1AttributeEncoder) {
                qualifier = ((SAML1AttributeEncoder)encoder).getNamespace();
            }
            String nameFormat = attr.getNameFormat();
            if (qualifier != null && nameFormat != null && !nameFormat.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified") && !qualifier.equals(nameFormat)) continue;
            return attr;
        }
        return null;
    }

    private boolean match(XMLObject xmlObj, String attributeValue) {
        XSAny wc;
        String toMatch = null;
        if (xmlObj instanceof XSString) {
            toMatch = ((XSString)xmlObj).getValue();
        } else if (xmlObj instanceof XSURI) {
            toMatch = ((XSURI)xmlObj).getValue();
        } else if (xmlObj instanceof XSBoolean) {
            toMatch = ((XSBoolean)xmlObj).getValue().getValue() != false ? "1" : "0";
        } else if (xmlObj instanceof XSInteger) {
            toMatch = ((XSInteger)xmlObj).getValue().toString();
        } else if (xmlObj instanceof XSDateTime) {
            DateTime dt = ((XSDateTime)xmlObj).getValue();
            if (dt != null) {
                toMatch = ((XSDateTime)xmlObj).getDateTimeFormatter().print((ReadableInstant)dt);
            }
        } else if (xmlObj instanceof XSBase64Binary) {
            toMatch = ((XSBase64Binary)xmlObj).getValue();
        } else if (xmlObj instanceof XSAny && (wc = (XSAny)xmlObj).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            toMatch = wc.getTextContent();
        }
        if (toMatch != null) {
            return toMatch.equals(attributeValue);
        }
        this.log.warn("Unrecognized XMLObject type, unable to match as a string to candidate value");
        return false;
    }
}

