/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.handler.AttributeHandler;
import edu.vt.middleware.ldap.handler.CaseChangeAttributeHandler;
import edu.vt.middleware.ldap.handler.CopySearchResultHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import javax.naming.directory.SearchResult;

public class CaseChangeSearchResultHandler
extends CopySearchResultHandler {
    private CaseChange dnCaseChange = CaseChange.NONE;
    private CaseChangeAttributeHandler attributeHandler = new CaseChangeAttributeHandler();

    public CaseChangeSearchResultHandler() {
        this.setAttributeHandler(new AttributeHandler[]{this.attributeHandler});
    }

    public CaseChange getDnCaseChange() {
        return this.dnCaseChange;
    }

    public void setDnCaseChange(CaseChange caseChange) {
        this.dnCaseChange = caseChange;
    }

    public CaseChange getAttributeNameCaseChange() {
        return this.attributeHandler.getAttributeNameCaseChange();
    }

    public void setAttributeNameCaseChange(CaseChange caseChange) {
        this.attributeHandler.setAttributeNameCaseChange(caseChange);
    }

    public CaseChange getAttributeValueCaseChange() {
        return this.attributeHandler.getAttributeValueCaseChange();
    }

    public void setAttributeValueCaseChange(CaseChange caseChange) {
        this.attributeHandler.setAttributeValueCaseChange(caseChange);
    }

    protected String processDn(SearchCriteria sc, SearchResult sr) {
        return CaseChange.perform(this.dnCaseChange, sr.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CaseChange {
        NONE,
        LOWER,
        UPPER;


        public static String perform(CaseChange cc, String string) {
            String s = null;
            if (LOWER == cc) {
                s = string.toLowerCase();
            } else if (UPPER == cc) {
                s = string.toUpperCase();
            } else if (NONE == cc) {
                s = string;
            }
            return s;
        }
    }
}

