/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.handler.ConnectionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionHandler
implements ConnectionHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected LdapConfig config;
    protected LdapContext context;
    protected ConnectionHandler.ConnectionStrategy connectionStrategy = ConnectionHandler.ConnectionStrategy.DEFAULT;
    protected Class<?>[] connectionRetryExceptions = new Class[]{NamingException.class};
    private ConnectionCount connectionCount = new ConnectionCount();

    protected ConnectionCount getConnectionCount() {
        return this.connectionCount;
    }

    protected void setConnectionCount(ConnectionCount cc) {
        this.connectionCount = cc;
    }

    @Override
    public ConnectionHandler.ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    @Override
    public void setConnectionStrategy(ConnectionHandler.ConnectionStrategy strategy) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting connectionStrategy: " + (Object)((Object)strategy)));
        }
        this.connectionStrategy = strategy;
    }

    @Override
    public Class<?>[] getConnectionRetryExceptions() {
        return this.connectionRetryExceptions;
    }

    @Override
    public void setConnectionRetryExceptions(Class<?>[] exceptions) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting connectionRetryExceptions: " + Arrays.toString(exceptions)));
        }
        this.connectionRetryExceptions = exceptions;
    }

    @Override
    public LdapConfig getLdapConfig() {
        return this.config;
    }

    @Override
    public void setLdapConfig(LdapConfig lc) {
        this.config = lc;
    }

    @Override
    public LdapContext getLdapContext() {
        return this.context;
    }

    @Override
    public void connect(String dn, Object credential) throws NamingException {
        String[] urls;
        NamingException lastThrown = null;
        for (String url : urls = this.parseLdapUrl(this.config.getLdapUrl(), this.connectionStrategy)) {
            Hashtable<String, Object> env = new Hashtable<String, Object>(this.config.getEnvironment());
            env.put("java.naming.provider.url", url);
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("{" + this.connectionCount + "} Attempting connection to " + url + " for strategy " + (Object)((Object)this.connectionStrategy)));
                }
                this.connectInternal(this.config.getAuthtype(), dn, credential, env);
                this.connectionCount.incrementCount();
                lastThrown = null;
                break;
            }
            catch (NamingException e) {
                lastThrown = e;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Error connecting to LDAP URL: " + url), (Throwable)e);
                }
                boolean ignoreException = false;
                if (this.connectionRetryExceptions != null && this.connectionRetryExceptions.length > 0) {
                    for (Class<?> ne : this.connectionRetryExceptions) {
                        if (!ne.isInstance(e)) continue;
                        ignoreException = true;
                        break;
                    }
                }
                if (!ignoreException) break;
            }
        }
        if (lastThrown != null) {
            throw lastThrown;
        }
    }

    protected abstract void connectInternal(String var1, String var2, Object var3, Hashtable<String, Object> var4) throws NamingException;

    @Override
    public boolean isConnected() {
        return this.context != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws NamingException {
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        finally {
            this.context = null;
        }
    }

    @Override
    public abstract ConnectionHandler newInstance();

    protected String[] parseLdapUrl(String ldapUrl, ConnectionHandler.ConnectionStrategy strategy) {
        String[] urls = null;
        if (strategy == ConnectionHandler.ConnectionStrategy.DEFAULT) {
            urls = new String[]{ldapUrl};
        } else if (strategy == ConnectionHandler.ConnectionStrategy.ACTIVE_PASSIVE) {
            List<String> l = this.splitLdapUrl(ldapUrl);
            urls = l.toArray(new String[l.size()]);
        } else if (strategy == ConnectionHandler.ConnectionStrategy.ROUND_ROBIN) {
            List<String> l = this.splitLdapUrl(ldapUrl);
            for (int i = 0; i < this.connectionCount.getCount() % l.size(); ++i) {
                l.add(l.remove(0));
            }
            urls = l.toArray(new String[l.size()]);
        } else if (strategy == ConnectionHandler.ConnectionStrategy.RANDOM) {
            List<String> l = this.splitLdapUrl(ldapUrl);
            Collections.shuffle(l);
            urls = l.toArray(new String[l.size()]);
        }
        return urls;
    }

    private List<String> splitLdapUrl(String url) {
        ArrayList<String> urls = new ArrayList<String>();
        if (url != null) {
            StringTokenizer st = new StringTokenizer(url);
            while (st.hasMoreTokens()) {
                urls.add(st.nextToken());
            }
        } else {
            urls.add(null);
        }
        return urls;
    }

    private class ConnectionCount {
        private int count;

        private ConnectionCount() {
        }

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
            if (this.count < 0) {
                this.count = 0;
            }
        }

        public String toString() {
            return Integer.toString(this.count);
        }
    }
}

