/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.bean;

import edu.vt.middleware.ldap.bean.AbstractLdapBean;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLdapAttributes<T extends Map<String, LdapAttribute>>
extends AbstractLdapBean
implements LdapAttributes {
    public static final boolean DEFAULT_IGNORE_CASE = true;
    protected static final int HASH_CODE_SEED = 42;
    protected T attributes;

    public AbstractLdapAttributes(LdapBeanFactory lbf) {
        super(lbf);
    }

    @Override
    public Collection<LdapAttribute> getAttributes() {
        return this.attributes.values();
    }

    @Override
    public LdapAttribute getAttribute(String name) {
        return (LdapAttribute)this.attributes.get(name);
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    @Override
    public void addAttribute(LdapAttribute a) {
        this.attributes.put((String)a.getName(), (LdapAttribute)a);
    }

    @Override
    public void addAttribute(String name, Object value) {
        LdapAttribute la = this.beanFactory.newLdapAttribute();
        la.setName(name);
        la.getValues().add(value);
        this.addAttribute(la);
    }

    @Override
    public void addAttribute(String name, List<?> values) {
        LdapAttribute la = this.beanFactory.newLdapAttribute();
        la.setName(name);
        la.getValues().addAll(values);
        this.addAttribute(la);
    }

    @Override
    public void addAttributes(Collection<LdapAttribute> c) {
        for (LdapAttribute la : c) {
            this.addAttribute(la);
        }
    }

    @Override
    public void addAttributes(Attributes a) throws NamingException {
        NamingEnumeration<? extends Attribute> ne = a.getAll();
        while (ne.hasMore()) {
            LdapAttribute la = this.beanFactory.newLdapAttribute();
            la.setAttribute(ne.next());
            this.addAttribute(la);
        }
    }

    @Override
    public void removeAttribute(LdapAttribute a) {
        this.attributes.remove(a.getName());
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void removeAttributes(Collection<LdapAttribute> c) {
        for (LdapAttribute la : c) {
            this.removeAttribute(la);
        }
    }

    @Override
    public void removeAttributes(Attributes a) throws NamingException {
        NamingEnumeration<? extends Attribute> ne = a.getAll();
        while (ne.hasMore()) {
            LdapAttribute la = this.beanFactory.newLdapAttribute();
            la.setAttribute(ne.next());
            this.removeAttribute(la);
        }
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public int hashCode() {
        int hc = 42;
        for (LdapAttribute a : this.attributes.values()) {
            if (a == null) continue;
            hc += a.hashCode();
        }
        return hc;
    }

    public String toString() {
        return String.format("%s", this.attributes.values());
    }

    @Override
    public Attributes toAttributes() {
        BasicAttributes attributes = new BasicAttributes(true);
        for (LdapAttribute a : this.attributes.values()) {
            attributes.put(a.toAttribute());
        }
        return attributes;
    }
}

