/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.AbstractRequestURIMappedProfileHandler;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SAMLMetadataProfileHandler
extends AbstractRequestURIMappedProfileHandler {
    private final Logger log = LoggerFactory.getLogger(SAMLMetadataProfileHandler.class);
    private FilesystemMetadataProvider metadataProvider;

    public SAMLMetadataProfileHandler(String metadataFile, ParserPool pool) {
        try {
            this.metadataProvider = new FilesystemMetadataProvider(new File(metadataFile));
            this.metadataProvider.setParserPool(pool);
            this.metadataProvider.setRequireValidMetadata(false);
            this.metadataProvider.initialize();
        }
        catch (Exception e) {
            this.log.error("Unable to read metadata file " + metadataFile, (Throwable)e);
        }
    }

    public void processRequest(InTransport in, OutTransport out) throws ProfileException {
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)in).getWrappedRequest();
        HttpServletResponse httpResponse = ((HttpServletResponseAdapter)out).getWrappedResponse();
        String acceptHeder = DatatypeHelper.safeTrimOrNullString((String)httpRequest.getHeader("Accept"));
        if (acceptHeder != null && !acceptHeder.contains("application/samlmetadata+xml")) {
            httpResponse.setContentType("application/xml");
        } else {
            httpResponse.setContentType("application/samlmetadata+xml");
        }
        try {
            String requestedEntity = DatatypeHelper.safeTrimOrNullString((String)((HttpServletRequestAdapter)in).getParameterValue("entity"));
            Object metadata = requestedEntity != null ? this.metadataProvider.getEntityDescriptor(requestedEntity) : this.metadataProvider.getMetadata();
            if (metadata != null) {
                Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(metadata);
                this.writeNode(marshaller.marshall(metadata), out.getOutgoingStream(), Charset.forName("UTF-8"));
            }
        }
        catch (Exception e) {
            this.log.error("Unable to retrieve and return metadata", (Throwable)e);
            throw new ProfileException((Throwable)e);
        }
    }

    private void writeNode(Node node, OutputStream output, Charset outputEncoding) {
        DOMImplementationLS domImplLS = XMLHelper.getLSDOMImpl((Node)node);
        LSSerializer serializer = XMLHelper.getLSSerializer((DOMImplementationLS)domImplLS, null);
        LSOutput serializerOut = domImplLS.createLSOutput();
        serializerOut.setEncoding(outputEncoding.name());
        serializerOut.setByteStream(output);
        serializer.write(node, serializerOut);
    }
}

