/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ant.pki;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SelfSignedCertificate
extends Task {
    private String keyType = "RSA";
    private int keysize = 2048;
    private int certificateLifetime = 20;
    private String hostname;
    private String[] dnsSubjectAltNames;
    private String[] uriSubjectAltNames;
    private File privateKeyFile;
    private File certificateFile;
    private File keystoreFile;
    private String keystorePassword;

    public void execute() {
        this.validate();
        KeyPair keypair = this.generateKeyPair();
        X509Certificate certificate = this.generateCertificate(keypair);
        if (this.privateKeyFile != null) {
            try {
                this.privateKeyFile.createNewFile();
                JcaPEMWriter keyOut = new JcaPEMWriter((Writer)new FileWriter(this.privateKeyFile));
                keyOut.writeObject((Object)keypair.getPrivate());
                keyOut.flush();
                keyOut.close();
            }
            catch (Exception e) {
                this.log(e.toString(), 0);
                throw new BuildException("Unable to create private key file.", (Throwable)e);
            }
        }
        if (this.certificateFile != null) {
            try {
                this.certificateFile.createNewFile();
                JcaPEMWriter certOut = new JcaPEMWriter((Writer)new FileWriter(this.certificateFile));
                certOut.writeObject((Object)certificate);
                certOut.flush();
                certOut.close();
            }
            catch (Exception e) {
                this.log(e.toString(), 0);
                throw new BuildException("Unable to create certificate file.", (Throwable)e);
            }
        }
        if (this.keystoreFile != null) {
            try {
                KeyStore store = KeyStore.getInstance("JKS");
                store.load(null, null);
                store.setKeyEntry(this.hostname, keypair.getPrivate(), this.keystorePassword.toCharArray(), new X509Certificate[]{certificate});
                FileOutputStream keystoreOut = new FileOutputStream(this.keystoreFile);
                store.store(keystoreOut, this.keystorePassword.toCharArray());
                keystoreOut.flush();
                keystoreOut.close();
            }
            catch (Exception e) {
                this.log(e.toString(), 1);
                throw new BuildException("Unable to create keystore file.", (Throwable)e);
            }
        }
    }

    public void setKeyType(KeyType type) {
        this.keyType = type.getValue();
    }

    public void setKeysize(int size) {
        this.keysize = size;
    }

    public void setCertificateLifetime(int lifetime) {
        this.certificateLifetime = lifetime;
    }

    public void setHostName(String name) {
        this.hostname = name;
    }

    public void setPrivateKeyFile(File file) {
        this.privateKeyFile = file;
    }

    public void setCertificateFile(File file) {
        this.certificateFile = file;
    }

    public void setKeystoreFile(File file) {
        this.keystoreFile = file;
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    public void setDnsSubjectAltNames(String altNames) {
        this.dnsSubjectAltNames = altNames.split(" ");
    }

    public void setUriSubjectAltNames(String altNames) {
        this.uriSubjectAltNames = altNames.split(" ");
    }

    protected void validate() {
        if (this.keysize > 2048) {
            this.log("Key size is greater than 2048, this may cause problems with some JVMs", 1);
        }
        if (this.hostname == null || this.hostname.length() == 0) {
            throw new BuildException("The hostname attribute is required and may not contain an empty value");
        }
        if (this.keystoreFile != null && (this.keystorePassword == null || this.keystorePassword.length() == 0)) {
            throw new BuildException("Keystore password may not be null if a keystore file is given");
        }
    }

    protected KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(this.keyType);
            generator.initialize(this.keysize);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException("The " + this.keyType + " key type is not supported by this JVM");
        }
    }

    protected X509Certificate generateCertificate(KeyPair keypair) {
        try {
            X500Name dn = new X500Name("CN=" + this.hostname);
            GregorianCalendar notBefore = new GregorianCalendar();
            GregorianCalendar notOnOrAfter = new GregorianCalendar();
            notOnOrAfter.set(1, notOnOrAfter.get(1) + this.certificateLifetime);
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(dn, new BigInteger(160, new SecureRandom()), notBefore.getTime(), notOnOrAfter.getTime(), dn, keypair.getPublic());
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keypair.getPublic()));
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)GeneralNames.getInstance((Object)new DERSequence(this.buildSubjectAltNames())));
            X509CertificateHolder certHldr = builder.build(new JcaContentSignerBuilder("SHA1withRSA").build(keypair.getPrivate()));
            X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHldr);
            cert.checkValidity(new Date());
            cert.verify(keypair.getPublic());
            return cert;
        }
        catch (Exception e) {
            this.log(e.toString(), 0);
            throw new BuildException("Unable to generate self-signed certificate", (Throwable)e);
        }
    }

    protected ASN1Encodable[] buildSubjectAltNames() {
        ArrayList<GeneralName> subjectAltNames = new ArrayList<GeneralName>();
        subjectAltNames.add(new GeneralName(2, this.hostname));
        if (this.dnsSubjectAltNames != null) {
            for (String subjectAltName : this.dnsSubjectAltNames) {
                subjectAltNames.add(new GeneralName(2, subjectAltName));
            }
        }
        if (this.uriSubjectAltNames != null) {
            for (String subjectAltName : this.uriSubjectAltNames) {
                subjectAltNames.add(new GeneralName(6, subjectAltName));
            }
        }
        return subjectAltNames.toArray(new ASN1Encodable[0]);
    }

    public static class KeyType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"DSA", "RSA"};
        }
    }
}

