/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.idp.ui.ServiceTagSupport;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNameTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 8883158293402992407L;
    private static Logger log = LoggerFactory.getLogger(ServiceNameTag.class);
    private static final String DEFAULT_VALUE = "Unspecified Service Provider";

    public int doStartTag() throws JspException {
        try {
            String rawServiceName = this.getServiceName();
            Encoder esapiEncoder = ESAPI.encoder();
            String serviceName = esapiEncoder.encodeForHTML(rawServiceName);
            if (null == serviceName) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                boolean written = false;
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                    written = true;
                }
                if (!written) {
                    this.pageContext.getOut().print(DEFAULT_VALUE);
                }
            } else {
                this.pageContext.getOut().print(serviceName);
            }
        }
        catch (IOException e) {
            log.warn("Error generating name");
            throw new JspException("StartTag", (Throwable)e);
        }
        return super.doStartTag();
    }
}

