/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.jaas;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapGroup
implements Group,
Serializable {
    private static final long serialVersionUID = -342760961669842632L;
    private String name;
    private Set<Principal> members = new HashSet<Principal>();

    public LdapGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean addMember(Principal user) {
        return this.members.add(user);
    }

    public boolean removeMember(Principal user) {
        return this.members.remove(user);
    }

    public boolean isMember(Principal member) {
        for (Principal p : this.members) {
            if (p.getName() == null || !p.getName().equals(member.getName())) continue;
            return true;
        }
        return false;
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this.members);
    }

    public Set<Principal> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public String toString() {
        return String.format("%s%s", this.name, this.members);
    }
}

