/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.AbstractLdap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.handler.AttributeHandler;
import edu.vt.middleware.ldap.handler.ExtendedAttributeHandler;
import edu.vt.middleware.ldap.handler.ExtendedSearchResultHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import edu.vt.middleware.ldap.handler.SearchResultHandler;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ldap
extends AbstractLdap<LdapConfig>
implements Serializable {
    private static final long serialVersionUID = -2715321533384426365L;

    public Ldap() {
    }

    public Ldap(LdapConfig ldapConfig) {
        this.setLdapConfig(ldapConfig);
    }

    @Override
    public void setLdapConfig(LdapConfig ldapConfig) {
        super.setLdapConfig(ldapConfig);
    }

    public LdapConfig getLdapConfig() {
        return this.config;
    }

    public void loadFromProperties() {
        this.setLdapConfig(LdapConfig.createFromProperties(null));
    }

    public void loadFromProperties(InputStream is) {
        this.setLdapConfig(LdapConfig.createFromProperties(is));
    }

    public boolean compare(SearchFilter filter) throws NamingException {
        return this.compare(this.config.getBaseDn(), filter);
    }

    public boolean compare(String dn, SearchFilter filter) throws NamingException {
        return super.compare(dn, filter.getFilter(), filter.getFilterArgs().toArray());
    }

    public Iterator<SearchResult> search(SearchFilter filter) throws NamingException {
        return this.search(this.config.getBaseDn(), filter, this.config.getSearchControls(null));
    }

    public Iterator<SearchResult> search(SearchFilter filter, String[] retAttrs) throws NamingException {
        return this.search(this.config.getBaseDn(), filter, this.config.getSearchControls(retAttrs));
    }

    public Iterator<SearchResult> search(SearchFilter filter, SearchControls searchControls) throws NamingException {
        return this.search(this.config.getBaseDn(), filter, searchControls);
    }

    public Iterator<SearchResult> search(String dn, SearchFilter filter) throws NamingException {
        return this.search(dn, filter, this.config.getSearchControls(null));
    }

    public Iterator<SearchResult> search(String dn, SearchFilter filter, String[] retAttrs) throws NamingException {
        return this.search(dn, filter, this.config.getSearchControls(retAttrs), this.config.getSearchResultHandlers());
    }

    public Iterator<SearchResult> search(String dn, SearchFilter filter, SearchControls searchControls) throws NamingException {
        return this.search(dn, filter, searchControls, this.config.getSearchResultHandlers());
    }

    public Iterator<SearchResult> search(String dn, SearchFilter filter, String[] retAttrs, SearchResultHandler ... handler) throws NamingException {
        return this.search(dn, filter, this.config.getSearchControls(retAttrs), handler);
    }

    public Iterator<SearchResult> search(String dn, SearchFilter filter, SearchControls searchControls, SearchResultHandler ... handler) throws NamingException {
        if (handler != null && handler.length > 0) {
            for (SearchResultHandler h : handler) {
                AttributeHandler[] attrHandler;
                if (ExtendedSearchResultHandler.class.isInstance(h)) {
                    ((ExtendedSearchResultHandler)h).setSearchResultLdap(this);
                }
                if ((attrHandler = h.getAttributeHandler()) == null || attrHandler.length <= 0) continue;
                for (AttributeHandler ah : attrHandler) {
                    if (!ExtendedAttributeHandler.class.isInstance(ah)) continue;
                    ((ExtendedAttributeHandler)ah).setSearchResultLdap(this);
                }
            }
        }
        if (this.config.getPagedResultsSize() > 0) {
            return super.pagedSearch(dn, filter.getFilter(), filter.getFilterArgs().toArray(), searchControls, handler);
        }
        return super.search(dn, filter.getFilter(), filter.getFilterArgs().toArray(), searchControls, handler);
    }

    public Iterator<SearchResult> searchAttributes(Attributes matchAttrs) throws NamingException {
        return this.searchAttributes(this.config.getBaseDn(), matchAttrs, null);
    }

    public Iterator<SearchResult> searchAttributes(Attributes matchAttrs, String[] retAttrs) throws NamingException {
        return this.searchAttributes(this.config.getBaseDn(), matchAttrs, retAttrs);
    }

    public Iterator<SearchResult> searchAttributes(String dn, Attributes matchAttrs) throws NamingException {
        return this.searchAttributes(dn, matchAttrs, null);
    }

    public Iterator<SearchResult> searchAttributes(String dn, Attributes matchAttrs, String[] retAttrs) throws NamingException {
        return this.searchAttributes(dn, matchAttrs, retAttrs, this.config.getSearchResultHandlers());
    }

    @Override
    public Iterator<SearchResult> searchAttributes(String dn, Attributes matchAttrs, String[] retAttrs, SearchResultHandler ... handler) throws NamingException {
        if (handler != null && handler.length > 0) {
            for (SearchResultHandler h : handler) {
                AttributeHandler[] attrHandler;
                if (ExtendedSearchResultHandler.class.isInstance(h)) {
                    ((ExtendedSearchResultHandler)h).setSearchResultLdap(this);
                }
                if ((attrHandler = h.getAttributeHandler()) == null || attrHandler.length <= 0) continue;
                for (AttributeHandler ah : attrHandler) {
                    if (!ExtendedAttributeHandler.class.isInstance(ah)) continue;
                    ((ExtendedAttributeHandler)ah).setSearchResultLdap(this);
                }
            }
        }
        return super.searchAttributes(dn, matchAttrs, retAttrs, handler);
    }

    @Override
    public Iterator<NameClassPair> list(String dn) throws NamingException {
        return super.list(dn);
    }

    @Override
    public Iterator<Binding> listBindings(String dn) throws NamingException {
        return super.listBindings(dn);
    }

    public Attributes getAttributes(String dn) throws NamingException {
        return this.getAttributes(dn, null);
    }

    public Attributes getAttributes(String dn, String[] retAttrs) throws NamingException {
        return this.getAttributes(dn, retAttrs, new AttributeHandler[0]);
    }

    @Override
    public Attributes getAttributes(String dn, String[] retAttrs, AttributeHandler ... handler) throws NamingException {
        if (handler != null && handler.length > 0) {
            for (AttributeHandler h : handler) {
                if (!ExtendedAttributeHandler.class.isInstance(h)) continue;
                ((ExtendedAttributeHandler)h).setSearchResultLdap(this);
            }
        }
        return super.getAttributes(dn, retAttrs, handler);
    }

    @Override
    public Iterator<SearchResult> getSchema(String dn) throws NamingException {
        return super.getSchema(dn);
    }

    public void modifyAttributes(String dn, AttributeModification mod, Attributes attrs) throws NamingException {
        super.modifyAttributes(dn, mod.modOp(), attrs);
    }

    @Override
    public void modifyAttributes(String dn, ModificationItem[] mods) throws NamingException {
        super.modifyAttributes(dn, mods);
    }

    @Override
    public void create(String dn, Attributes attrs) throws NamingException {
        super.create(dn, attrs);
    }

    @Override
    public void rename(String oldDn, String newDn) throws NamingException {
        super.rename(oldDn, newDn);
    }

    @Override
    public void delete(String dn) throws NamingException {
        super.delete(dn);
    }

    public String[] getSaslMechanisms() throws NamingException {
        Attribute attr;
        Attributes attrs = this.getAttributes("", new String[]{"supportedSASLMechanisms"});
        String[] results = new String[]{};
        if (attrs != null && (attr = attrs.get("supportedSASLMechanisms")) != null) {
            results = COPY_RESULT_HANDLER.process(new SearchCriteria(""), attr.getAll()).toArray(results);
        }
        return results;
    }

    public String[] getSupportedControls() throws NamingException {
        Attribute attr;
        Attributes attrs = this.getAttributes("", new String[]{"supportedcontrol"});
        String[] results = new String[]{};
        if (attrs != null && (attr = attrs.get("supportedcontrol")) != null) {
            results = COPY_RESULT_HANDLER.process(new SearchCriteria(""), attr.getAll()).toArray(results);
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeModification {
        ADD(1),
        REPLACE(2),
        REMOVE(3);

        private int modOp;

        private AttributeModification(int i) {
            this.modOp = i;
        }

        public int modOp() {
            return this.modOp;
        }

        public static AttributeModification parseModificationOperation(int i) {
            AttributeModification am = null;
            if (ADD.modOp() == i) {
                am = ADD;
            } else if (REPLACE.modOp() == i) {
                am = REPLACE;
            } else if (REMOVE.modOp() == i) {
                am = REMOVE;
            }
            return am;
        }
    }
}

