/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.GraphDelegator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsWeightedGraph<V, E>
extends GraphDelegator<V, E>
implements Serializable,
WeightedGraph<V, E> {
    private static final long serialVersionUID = -716810639338971372L;
    protected final Map<E, Double> weightMap;
    private final boolean isWeightedGraph;

    public AsWeightedGraph(Graph<V, E> graph, Map<E, Double> map) {
        super(graph);
        assert (map != null);
        this.weightMap = map;
        this.isWeightedGraph = graph instanceof WeightedGraph;
    }

    @Override
    public void setEdgeWeight(E e, double d) {
        if (this.isWeightedGraph) {
            super.setEdgeWeight(e, d);
        }
        this.weightMap.put(e, d);
    }

    @Override
    public double getEdgeWeight(E e) {
        double d = this.weightMap.containsKey(e) ? this.weightMap.get(e).doubleValue() : super.getEdgeWeight(e);
        return d;
    }
}

