/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import edu.internet2.middleware.shibboleth.common.security.MetadataPKIXValidationInformationResolver;
import java.util.ArrayList;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.xml.security.keyinfo.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.DSAKeyValueProvider;
import org.opensaml.xml.security.keyinfo.provider.InlineX509DataProvider;
import org.opensaml.xml.security.keyinfo.provider.RSAKeyValueProvider;
import org.opensaml.xml.security.x509.CertPathPKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.PKIXValidationOptions;
import org.opensaml.xml.signature.impl.PKIXSignatureTrustEngine;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class MetadataPKIXSignatureTrustEngineFactoryBean
extends AbstractFactoryBean {
    private MetadataProvider metadataProvider;
    private PKIXValidationOptions pkixOptions;

    public PKIXValidationOptions getPKIXValidationOptions() {
        return this.pkixOptions;
    }

    public void setPKIXValidationOptions(PKIXValidationOptions newOptions) {
        this.pkixOptions = newOptions;
    }

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(MetadataProvider provider) {
        this.metadataProvider = provider;
    }

    public Class getObjectType() {
        return PKIXSignatureTrustEngine.class;
    }

    protected Object createInstance() throws Exception {
        MetadataPKIXValidationInformationResolver pviResolver = new MetadataPKIXValidationInformationResolver(this.getMetadataProvider());
        ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
        keyInfoProviders.add(new DSAKeyValueProvider());
        keyInfoProviders.add(new RSAKeyValueProvider());
        keyInfoProviders.add(new InlineX509DataProvider());
        BasicProviderKeyInfoCredentialResolver keyInfoCredResolver = new BasicProviderKeyInfoCredentialResolver(keyInfoProviders);
        PKIXSignatureTrustEngine engine = new PKIXSignatureTrustEngine((PKIXValidationInformationResolver)pviResolver, (KeyInfoCredentialResolver)keyInfoCredResolver);
        if (this.getPKIXValidationOptions() != null) {
            ((CertPathPKIXTrustEvaluator)engine.getPKIXTrustEvaluator()).setPKIXValidationOptions(this.getPKIXValidationOptions());
        }
        return engine;
    }
}

