/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config;

import edu.internet2.middleware.shibboleth.common.config.SpringDocumentLoader;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.Duration;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.InputStreamResource;
import org.w3c.dom.Element;

public final class SpringConfigurationUtils {
    private static Logger log = LoggerFactory.getLogger(SpringConfigurationUtils.class);

    private SpringConfigurationUtils() {
    }

    public static void populateRegistry(BeanDefinitionRegistry beanRegistry, List<Resource> configurationResources) throws ResourceException {
        XmlBeanDefinitionReader configReader = new XmlBeanDefinitionReader(beanRegistry);
        configReader.setValidationMode(3);
        configReader.setDocumentLoader((DocumentLoader)new SpringDocumentLoader());
        int numOfResources = configurationResources.size();
        org.springframework.core.io.Resource[] configSources = new org.springframework.core.io.Resource[numOfResources];
        for (int i = 0; i < numOfResources; ++i) {
            Resource configurationResource = configurationResources.get(i);
            if (configurationResource != null && configurationResource.exists()) {
                configSources[i] = new InputStreamResource(configurationResources.get(i).getInputStream(), configurationResource.getLocation());
                continue;
            }
            log.warn("Configuration resource not loaded because it does not exist: {}", (Object)configurationResource.getLocation());
        }
        try {
            configReader.loadBeanDefinitions(configSources);
        }
        catch (BeanDefinitionStoreException e) {
            throw new ResourceException("Unable to load Spring bean registry with configuration resources", (Exception)((Object)e));
        }
    }

    public static BeanDefinition parseInnerCustomElement(Element element, ParserContext parserContext) {
        return SpringConfigurationUtils.createBeanDefinition(element, parserContext);
    }

    public static ManagedList parseInnerCustomElements(List<Element> elements, ParserContext parserContext) {
        ManagedList beans = new ManagedList();
        if (elements != null) {
            for (Element element : elements) {
                beans.add((Object)SpringConfigurationUtils.parseInnerCustomElement(element, parserContext));
            }
        }
        return beans;
    }

    public static RuntimeBeanReference parseCustomElement(Element element, ParserContext parserContext) {
        return SpringConfigurationUtils.parseCustomElement(element, "id", parserContext);
    }

    public static RuntimeBeanReference parseCustomElement(Element element, String idAttribute, ParserContext parserContext) {
        SpringConfigurationUtils.createBeanDefinition(element, parserContext);
        RuntimeBeanReference beanRef = new RuntimeBeanReference(element.getAttributeNS(null, idAttribute));
        beanRef.setSource((Object)element);
        return beanRef;
    }

    private static BeanDefinition createBeanDefinition(Element element, ParserContext parserContext) {
        NamespaceHandler handler;
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        String namespaceUri = element.getNamespaceURI();
        if (XMLHelper.hasXSIType((Element)element)) {
            namespaceUri = XMLHelper.getXSIType((Element)element).getNamespaceURI();
        }
        if ((handler = delegate.getReaderContext().getNamespaceHandlerResolver().resolve(namespaceUri)) == null) {
            log.error("Unable to locate NamespaceHandler for namespace [" + namespaceUri + "]");
            return null;
        }
        return handler.parse(element, new ParserContext(delegate.getReaderContext(), delegate));
    }

    public static RuntimeBeanReference parseCustomElementReference(Element element, String refAttribute, ParserContext parserContext) {
        String reference = DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, refAttribute));
        if (reference != null) {
            return new RuntimeBeanReference(reference);
        }
        return null;
    }

    public static ManagedList parseCustomElements(List<Element> elements, ParserContext parserContext) {
        return SpringConfigurationUtils.parseCustomElements(elements, "id", parserContext);
    }

    public static ManagedList parseCustomElements(List<Element> elements, String idAttribute, ParserContext parserContext) {
        if (elements == null) {
            return null;
        }
        ManagedList definitions = new ManagedList(elements.size());
        for (Element e : elements) {
            definitions.add((Object)SpringConfigurationUtils.parseCustomElement(e, idAttribute, parserContext));
        }
        return definitions;
    }

    @Deprecated
    public static long parseDurationToMillis(String propertyName, String duration, int toMillisFactor) throws IllegalArgumentException {
        if (duration.startsWith("-")) {
            throw new IllegalArgumentException("Negative durations are not supported");
        }
        long millis = 0L;
        if (duration.startsWith("P")) {
            Duration xmlDuration = XMLHelper.getDataTypeFactory().newDuration(duration);
            millis = xmlDuration.getTimeInMillis(new Date());
        } else {
            try {
                millis = Long.parseLong(duration);
                if (millis < 0L) {
                    throw new IllegalArgumentException("Negative durations are not supported");
                }
                if (toMillisFactor > 0) {
                    millis *= (long)toMillisFactor;
                }
                Duration xmlDuration = XMLHelper.getDataTypeFactory().newDuration(millis);
                log.warn("Numerical duration form is deprecated. The property {} should use the duration notation: {}", (Object)propertyName, (Object)xmlDuration.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return millis;
    }
}

