/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.idp.ui.ServiceTagSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.opensaml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.LocalizedString;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.ServiceDescription;
import org.opensaml.samlext.saml2mdui.Description;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDescriptionTag
extends ServiceTagSupport {
    private static final long serialVersionUID = -2000941439055969537L;
    private static Logger log = LoggerFactory.getLogger(ServiceDescriptionTag.class);

    private String getDescriptionFromUIInfo(String lang) {
        if (this.getSPUIInfo() != null && this.getSPUIInfo().getDescriptions() != null) {
            for (Description desc : this.getSPUIInfo().getDescriptions()) {
                if (log.isDebugEnabled()) {
                    log.debug("Found description in UIInfo, language=" + desc.getXMLLang());
                }
                if (!desc.getXMLLang().equals(lang)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("returning description from UIInfo " + desc.getName().getLocalString());
                }
                return desc.getName().getLocalString();
            }
            if (log.isDebugEnabled()) {
                log.debug("No valid description in UIInfo");
            }
        }
        return null;
    }

    private String getDescriptionFromAttributeConsumingService(String lang) {
        AttributeConsumingService acs = null;
        EntityDescriptor sp = this.getSPEntityDescriptor();
        if (sp == null) {
            log.debug("No relying party, nothing to display");
            return null;
        }
        List roles = sp.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        if (!roles.isEmpty()) {
            SPSSODescriptor spssod = (SPSSODescriptor)roles.get(0);
            acs = spssod.getDefaultAttributeConsumingService();
        }
        if (acs != null) {
            for (ServiceDescription desc : acs.getDescriptions()) {
                LocalizedString localDescription = desc.getDescription();
                if (log.isDebugEnabled()) {
                    log.debug("Found name in AttributeConsumingService, language=" + localDescription.getLanguage());
                }
                if (!localDescription.getLanguage().equals(lang)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("returning name from AttributeConsumingService " + desc.getDescription().getLocalString());
                }
                return localDescription.getLocalString();
            }
            if (log.isDebugEnabled()) {
                log.debug("No description in AttributeConsumingService");
            }
        }
        return null;
    }

    public int doEndTag() throws JspException {
        Encoder esapiEncoder = ESAPI.encoder();
        String result = null;
        for (String lang : this.getBrowserLanguages()) {
            result = this.getDescriptionFromUIInfo(lang);
            if (result != null || (result = this.getDescriptionFromAttributeConsumingService(lang)) != null) break;
        }
        try {
            if (result == null) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (bc != null && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                result = esapiEncoder.encodeForHTML(result);
                this.pageContext.getOut().print(result);
            }
        }
        catch (IOException e) {
            log.warn("Error generating Description");
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

