/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.system.conf1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import edu.internet2.middleware.shibboleth.common.profile.provider.AbstractShibbolethProfileHandler;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.Saml2LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.UsernamePrincipal;
import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.impl.AuthenticationMethodInformationImpl;
import edu.internet2.middleware.shibboleth.idp.system.conf1.BaseConf1TestCase;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.util.storage.StorageService;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2SSOTestCase
extends BaseConf1TestCase {
    public void testFirstAuthenticationLeg() throws Exception {
        MockServletContext servletContext = new MockServletContext();
        MockHttpServletRequest servletRequest = this.buildServletRequest("urn:example.org:sp1");
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        AbstractShibbolethProfileHandler handler = (AbstractShibbolethProfileHandler)handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML2SSOTestCase.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        servletRequest.setCookies(servletResponse.getCookies());
        Saml2LoginContext loginContext = (Saml2LoginContext)HttpServletHelper.getLoginContext((StorageService)handler.getStorageService(), (ServletContext)servletContext, (HttpServletRequest)servletRequest);
        SAML2SSOTestCase.assertNotNull((Object)loginContext);
        SAML2SSOTestCase.assertEquals((boolean)false, (boolean)loginContext.getAuthenticationAttempted());
        SAML2SSOTestCase.assertEquals((boolean)false, (boolean)loginContext.isForceAuthRequired());
        SAML2SSOTestCase.assertEquals((boolean)false, (boolean)loginContext.isPassiveAuthRequired());
        SAML2SSOTestCase.assertEquals((String)"/AuthnEngine", (String)loginContext.getAuthenticationEngineURL());
        SAML2SSOTestCase.assertEquals((String)"/saml2/POST/SSO", (String)loginContext.getProfileHandlerURL());
        SAML2SSOTestCase.assertEquals((String)"urn:example.org:sp1", (String)loginContext.getRelyingPartyId());
        SAML2SSOTestCase.assertEquals((int)0, (int)loginContext.getRequestedAuthenticationMethods().size());
        SAML2SSOTestCase.assertTrue((boolean)servletResponse.getRedirectedUrl().endsWith("/AuthnEngine"));
    }

    public void testSecondAuthenticationLeg() throws Exception {
        MockServletContext servletContext = new MockServletContext();
        MockHttpServletRequest servletRequest = this.buildServletRequest("urn:example.org:sp1");
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        AbstractShibbolethProfileHandler handler = (AbstractShibbolethProfileHandler)handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML2SSOTestCase.assertNotNull((Object)handler);
        HttpServletHelper.bindLoginContext((LoginContext)this.buildLoginContext("urn:example.org:sp1"), (StorageService)handler.getStorageService(), (ServletContext)servletContext, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        servletRequest.setCookies(servletResponse.getCookies());
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML2SSOTestCase.assertTrue((boolean)response.contains("action=\"https&#x3a;&#x2f;&#x2f;example.org&#x2f;mySP\" method=\"post\""));
        SAML2SSOTestCase.assertTrue((boolean)response.contains("SAMLResponse"));
    }

    public void testAuthenticationWithoutConfiguredSSO() throws Exception {
        MockHttpServletRequest servletRequest = this.buildServletRequest("urn:example.org:BogusSP");
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML2SSOTestCase.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        try {
            handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
            SAML2SSOTestCase.fail((String)"Request processing expected to due to lack of configured SAML 2 SSO profile");
        }
        catch (ProfileException profileException) {
            // empty catch block
        }
    }

    protected MockHttpServletRequest buildServletRequest(String relyingPartyId) throws Exception {
        AuthnRequest authnRequest = this.buildAuthnRequest(relyingPartyId);
        String authnRequestString = this.getSamlRequestString(authnRequest);
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml2/POST/SSO");
        servletRequest.setParameter("SAMLRequest", Base64.encodeBytes((byte[])authnRequestString.getBytes()));
        return servletRequest;
    }

    protected Saml2LoginContext buildLoginContext(String relyingPartyId) throws Exception {
        UsernamePrincipal principal = new UsernamePrincipal("test");
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)principal);
        AuthenticationMethodInformationImpl authnInfo = new AuthenticationMethodInformationImpl(subject, (Principal)principal, "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified", new DateTime(), 3600L);
        AuthnRequest request = this.buildAuthnRequest(relyingPartyId);
        Saml2LoginContext loginContext = new Saml2LoginContext(relyingPartyId, null, request);
        loginContext.setAuthenticationMethodInformation((AuthenticationMethodInformation)authnInfo);
        loginContext.setPrincipalAuthenticated(true);
        loginContext.setRelyingParty(relyingPartyId);
        return loginContext;
    }

    protected AuthnRequest buildAuthnRequest(String relyingPartyId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(relyingPartyId);
        SAMLObjectBuilder authnRequestBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)authnRequestBuilder.buildObject();
        request.setID("1");
        request.setIssueInstant(new DateTime());
        request.setIssuer(issuer);
        return request;
    }

    protected String getSamlRequestString(AuthnRequest request) throws MarshallingException {
        Marshaller marshaller = this.marshallerFactory.getMarshaller((XMLObject)request);
        Element requestElem = marshaller.marshall((XMLObject)request);
        return XMLHelper.nodeToString((Node)requestElem);
    }
}

