/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.system.conf1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import edu.internet2.middleware.shibboleth.idp.system.conf1.BaseConf1TestCase;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml2.core.Artifact;
import org.opensaml.saml2.core.ArtifactResolve;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2ArtifactResolutionTest
extends BaseConf1TestCase {
    public void testArtifactResolution() throws Exception {
        String relyingPartyId = "urn:example.org:sp1";
        SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.stageArtifact(relyingPartyId);
        String soapMessage = this.buildRequestMessage(relyingPartyId, artifactEntry.getArtifact());
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml2/SOAP/ArtifactResolution");
        servletRequest.setContent(soapMessage.getBytes());
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML2ArtifactResolutionTest.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML2ArtifactResolutionTest.assertTrue((boolean)response.contains("saml2p:ArtifactResponse"));
        SAML2ArtifactResolutionTest.assertTrue((boolean)response.contains("urn:oasis:names:tc:SAML:2.0:status:Success"));
        SAML2ArtifactResolutionTest.assertTrue((boolean)response.contains("saml2:Assertion"));
    }

    public void testWithoutConfiguration() throws Exception {
        String relyingPartyId = "urn:example.org:BogusSP";
        SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.stageArtifact(relyingPartyId);
        String soapMessage = this.buildRequestMessage(relyingPartyId, artifactEntry.getArtifact());
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml2/SOAP/ArtifactResolution");
        servletRequest.setContent(soapMessage.getBytes());
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML2ArtifactResolutionTest.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML2ArtifactResolutionTest.assertTrue((boolean)response.contains("urn:oasis:names:tc:SAML:2.0:status:Success"));
        SAML2ArtifactResolutionTest.assertTrue((boolean)response.contains("urn:oasis:names:tc:SAML:2.0:status:RequestDenied"));
    }

    protected SAMLArtifactMap.SAMLArtifactMapEntry stageArtifact(String relyingPartyId) throws Exception {
        SAMLObjectBuilder assetionBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)assetionBuilder.buildObject();
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response response = (Response)responseBuilder.buildObject();
        response.getAssertions().add(assertion);
        SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        byte[] endpointIndex = byArray;
        MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
        byte[] source = sha1Digester.digest(relyingPartyId.getBytes());
        byte[] assertionHandle = new byte[20];
        handleGenerator.nextBytes(assertionHandle);
        SAML2ArtifactType0004 artifact = new SAML2ArtifactType0004(endpointIndex, source, assertionHandle);
        SAMLArtifactMap artifactMap = (SAMLArtifactMap)this.getApplicationContext().getBean("shibboleth.ArtifactMap");
        artifactMap.put(artifact.base64Encode(), relyingPartyId, "urn:example.org:idp1", (SAMLObject)response);
        return artifactMap.get(artifact.base64Encode());
    }

    protected String buildRequestMessage(String relyingPartyId, String artifact) throws Exception {
        SAMLObjectBuilder artifactBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Artifact.DEFAULT_ELEMENT_NAME);
        Artifact samlArt = (Artifact)artifactBuilder.buildObject();
        samlArt.setArtifact(artifact);
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        issuer.setValue(relyingPartyId);
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        ArtifactResolve request = (ArtifactResolve)requestBuilder.buildObject();
        request.setID("1");
        request.setIssuer(issuer);
        request.setIssueInstant(new DateTime());
        request.setArtifact(samlArt);
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(request);
        SOAPObjectBuilder envelopeBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envelopeBuilder.buildObject();
        envelope.setBody(body);
        Marshaller marshaller = this.marshallerFactory.getMarshaller((XMLObject)envelope);
        Element envelopeElem = marshaller.marshall((XMLObject)envelope);
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode((Node)envelopeElem, (Writer)writer);
        return writer.toString();
    }
}

