/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.idp.ShibTestBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.opensaml.Configuration;
import org.opensaml.util.resource.ClasspathResource;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TestCaseBase
extends XMLTestCase {
    protected static BasicParserPool parser;
    protected XMLObjectBuilderFactory builderFactory;
    protected MarshallerFactory marshallerFactory;
    protected UnmarshallerFactory unmarshallerFactory;
    private static Logger log;
    private List<Resource> configResources;

    static {
        log = LoggerFactory.getLogger(TestCaseBase.class);
    }

    protected void setUp() throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        try {
            ShibTestBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            TestCaseBase.fail((String)e.getMessage());
        }
        parser = new BasicParserPool();
        parser.setNamespaceAware(true);
        this.builderFactory = Configuration.getBuilderFactory();
        this.marshallerFactory = Configuration.getMarshallerFactory();
        this.unmarshallerFactory = Configuration.getUnmarshallerFactory();
        this.configResources = new ArrayList<Resource>();
    }

    protected ApplicationContext createSpringContext() throws ResourceException {
        return this.createSpringContext(this.configResources);
    }

    protected ApplicationContext createSpringContext(String config) throws ResourceException {
        String[] configs = new String[]{config};
        return this.createSpringContext(configs);
    }

    protected ApplicationContext createSpringContext(String[] configs) throws ResourceException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.addAll(this.configResources);
        if (configs != null) {
            String[] stringArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                String config = stringArray[n2];
                resources.add((Resource)new ClasspathResource(config));
                ++n2;
            }
        }
        return this.createSpringContext(resources);
    }

    protected ApplicationContext createSpringContext(List<Resource> configs) throws ResourceException {
        GenericApplicationContext gContext = new GenericApplicationContext();
        SpringConfigurationUtils.populateRegistry((BeanDefinitionRegistry)gContext, configs);
        gContext.refresh();
        return gContext;
    }

    public void assertEquals(Document expectedDOM, XMLObject xmlObject) {
        this.assertEquals("Marshalled DOM was not the same as the expected DOM", expectedDOM, xmlObject);
    }

    public void assertEquals(String failMessage, Document expectedDOM, XMLObject xmlObject) {
        Marshaller marshaller = this.marshallerFactory.getMarshaller(xmlObject);
        if (marshaller == null) {
            TestCaseBase.fail((String)("Unable to locate marshaller for " + xmlObject.getElementQName() + " can not perform equality check assertion"));
        }
        try {
            Element generatedDOM = marshaller.marshall(xmlObject, parser.newDocument());
            if (log.isDebugEnabled()) {
                log.debug("Marshalled DOM was " + XMLHelper.nodeToString((Node)generatedDOM));
            }
            this.assertXMLEqual(failMessage, expectedDOM, generatedDOM.getOwnerDocument());
        }
        catch (Exception e) {
            log.error("Marshalling failed with the following error:", (Throwable)e);
            TestCaseBase.fail((String)("Marshalling failed with the following error: " + e));
        }
    }

    protected XMLObject unmarshallElement(String elementFile) {
        try {
            Document doc = parser.parse(TestCaseBase.class.getResourceAsStream(elementFile));
            Element samlElement = doc.getDocumentElement();
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(samlElement);
            if (unmarshaller == null) {
                TestCaseBase.fail((String)"Unable to retrieve unmarshaller by DOM Element");
            }
            return unmarshaller.unmarshall(samlElement);
        }
        catch (XMLParserException e) {
            TestCaseBase.fail((String)("Unable to parse element file " + elementFile));
        }
        catch (UnmarshallingException e) {
            TestCaseBase.fail((String)("Unmarshalling failed when parsing element file " + elementFile + ": " + (Object)((Object)e)));
        }
        return null;
    }
}

