/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.ssl.AggregateTrustManager;
import edu.vt.middleware.ldap.ssl.DefaultHostnameVerifier;
import edu.vt.middleware.ldap.ssl.DefaultSSLContextInitializer;
import edu.vt.middleware.ldap.ssl.HostnameVerifyingTrustManager;
import edu.vt.middleware.ldap.ssl.SSLContextInitializer;
import edu.vt.middleware.ldap.ssl.TLSSocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ThreadLocalTLSSocketFactory
extends TLSSocketFactory {
    private static final ThreadLocalSslConfig THREAD_LOCAL_SSL_CONFIG = new ThreadLocalSslConfig();

    public SSLContextInitializer getSSLContextInitializer() {
        return (SSLContextInitializer)THREAD_LOCAL_SSL_CONFIG.get();
    }

    public void setSSLContextInitializer(SSLContextInitializer initializer) {
        THREAD_LOCAL_SSL_CONFIG.set(initializer);
    }

    public static SocketFactory getDefault() {
        ThreadLocalTLSSocketFactory sf = new ThreadLocalTLSSocketFactory();
        if (sf.getSSLContextInitializer() == null) {
            throw new NullPointerException("Thread local sslContextInitializer has not been set");
        }
        try {
            sf.initialize();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Error initializing socket factory", e);
        }
        return sf;
    }

    public static SSLSocketFactory getHostnameVerifierFactory(String[] names) {
        ThreadLocalTLSSocketFactory sf = new ThreadLocalTLSSocketFactory();
        DefaultSSLContextInitializer ctxInit = new DefaultSSLContextInitializer();
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            TrustManager[] tm = tmf.getTrustManagers();
            X509TrustManager[] aggregate = new X509TrustManager[tm != null ? tm.length + 1 : 1];
            if (tm != null) {
                for (int i = 0; i < tm.length; ++i) {
                    aggregate[i] = (X509TrustManager)tm[i];
                }
            }
            aggregate[aggregate.length - 1] = new HostnameVerifyingTrustManager(new DefaultHostnameVerifier(), names);
            ctxInit.setTrustManagers(new TrustManager[]{new AggregateTrustManager(aggregate)});
            sf.setSSLContextInitializer(ctxInit);
            sf.initialize();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
        return sf;
    }

    public String toString() {
        return String.format("%s@%d::sslContextInitializer=%s,factory=%s,enabledCipherSuites=%s,enabledProtocols=%s", this.getClass().getName(), this.hashCode(), this.getSSLContextInitializer(), this.getFactory(), this.getEnabledCipherSuites(), this.getEnabledProtocols());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalSslConfig
    extends ThreadLocal<SSLContextInitializer> {
        private ThreadLocalSslConfig() {
        }
    }
}

