/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.util;

public class Base32 {
    private static final String base32Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final byte[] base32Lookup;
    private static final String errorCanonicalLength = "non canonical Base32 string length";
    private static final String errorCanonicalEnd = "non canonical bits at end of Base32 string";
    private static final String errorInvalidChar = "invalid character in Base32 string";

    static {
        byte[] byArray = new byte[73];
        byArray[0] = 26;
        byArray[1] = 27;
        byArray[2] = 28;
        byArray[3] = 29;
        byArray[4] = 30;
        byArray[5] = 31;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[16] = 1;
        byArray[17] = 2;
        byArray[18] = 3;
        byArray[19] = 4;
        byArray[20] = 5;
        byArray[21] = 6;
        byArray[22] = 7;
        byArray[23] = 8;
        byArray[24] = 9;
        byArray[25] = 10;
        byArray[26] = 11;
        byArray[27] = 12;
        byArray[28] = 13;
        byArray[29] = 14;
        byArray[30] = 15;
        byArray[31] = 16;
        byArray[32] = 17;
        byArray[33] = 18;
        byArray[34] = 19;
        byArray[35] = 20;
        byArray[36] = 21;
        byArray[37] = 22;
        byArray[38] = 23;
        byArray[39] = 24;
        byArray[40] = 25;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[48] = 1;
        byArray[49] = 2;
        byArray[50] = 3;
        byArray[51] = 4;
        byArray[52] = 5;
        byArray[53] = 6;
        byArray[54] = 7;
        byArray[55] = 8;
        byArray[56] = 9;
        byArray[57] = 10;
        byArray[58] = 11;
        byArray[59] = 12;
        byArray[60] = 13;
        byArray[61] = 14;
        byArray[62] = 15;
        byArray[63] = 16;
        byArray[64] = 17;
        byArray[65] = 18;
        byArray[66] = 19;
        byArray[67] = 20;
        byArray[68] = 21;
        byArray[69] = 22;
        byArray[70] = 23;
        byArray[71] = 24;
        byArray[72] = 25;
        base32Lookup = byArray;
    }

    public static String encode(byte[] bytes) {
        StringBuffer base32 = new StringBuffer((bytes.length * 8 + 4) / 5);
        int i = 0;
        while (i < bytes.length) {
            int currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(currByte >> 3));
            int digit = (currByte & 7) << 2;
            if (i >= bytes.length) {
                base32.append(base32Chars.charAt(digit));
                break;
            }
            currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(digit | currByte >> 6));
            base32.append(base32Chars.charAt(currByte >> 1 & 0x1F));
            digit = (currByte & 1) << 4;
            if (i >= bytes.length) {
                base32.append(base32Chars.charAt(digit));
                break;
            }
            currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(digit | currByte >> 4));
            digit = (currByte & 0xF) << 1;
            if (i >= bytes.length) {
                base32.append(base32Chars.charAt(digit));
                break;
            }
            currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(digit | currByte >> 7));
            base32.append(base32Chars.charAt(currByte >> 2 & 0x1F));
            digit = (currByte & 3) << 3;
            if (i >= bytes.length) {
                base32.append(base32Chars.charAt(digit));
                break;
            }
            currByte = bytes[i++] & 0xFF;
            base32.append(base32Chars.charAt(digit | currByte >> 5));
            base32.append(base32Chars.charAt(currByte & 0x1F));
        }
        return base32.toString();
    }

    public static byte[] decode(String base32) throws IllegalArgumentException {
        switch (base32.length() % 8) {
            case 1: 
            case 3: 
            case 6: {
                throw new IllegalArgumentException(errorCanonicalLength);
            }
        }
        byte[] bytes = new byte[base32.length() * 5 / 8];
        int offset = 0;
        int i = 0;
        while (i < base32.length()) {
            int lookup;
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byte digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byte nextByte = (byte)(digit << 3);
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit >> 2);
            nextByte = (byte)((digit & 3) << 6);
            if (i >= base32.length()) {
                if (nextByte == 0) break;
                throw new IllegalArgumentException(errorCanonicalEnd);
            }
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            nextByte = (byte)(nextByte | (byte)(digit << 1));
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit >> 4);
            nextByte = (byte)((digit & 0xF) << 4);
            if (i >= base32.length()) {
                if (nextByte == 0) break;
                throw new IllegalArgumentException(errorCanonicalEnd);
            }
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit >> 1);
            nextByte = (byte)((digit & 1) << 7);
            if (i >= base32.length()) {
                if (nextByte == 0) break;
                throw new IllegalArgumentException(errorCanonicalEnd);
            }
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            nextByte = (byte)(nextByte | (byte)(digit << 2));
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit >> 3);
            nextByte = (byte)((digit & 7) << 5);
            if (i >= base32.length()) {
                if (nextByte == 0) break;
                throw new IllegalArgumentException(errorCanonicalEnd);
            }
            if ((lookup = base32.charAt(i++) - 50) < 0 || lookup >= base32Lookup.length) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            digit = base32Lookup[lookup];
            if (digit == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            bytes[offset++] = (byte)(nextByte | digit);
        }
        return bytes;
    }
}

