/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapPoolStrategy;
import edu.vt.middleware.ldap.BaseLdap;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.pool.LdapFactory;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPoolEmptyStrategy
implements LdapPoolStrategy {
    private final Logger log = LoggerFactory.getLogger(LdapPoolEmptyStrategy.class);
    private LdapFactory<Ldap> ldapFactory;

    @Override
    public void setLdapPoolConfig(LdapPoolConfig config) {
    }

    @Override
    public void setLdapFactory(LdapFactory<Ldap> factory) {
        this.ldapFactory = factory;
    }

    @Override
    public void setBlockWhenEmpty(boolean block) {
    }

    @Override
    public void initialize() {
        Ldap ldap = null;
        try {
            try {
                ldap = this.checkOut();
                if (ldap == null) {
                    this.log.error("Unable to retrieve an LDAP connection");
                    throw new AttributeResolutionException("Unable to retrieve LDAP connection");
                }
                if (!ldap.connect()) {
                    throw new RuntimeException("Unable to connect to LDAP server");
                }
            }
            catch (NamingException e) {
                this.log.error("An error occured when attempting to search the LDAP: " + ldap.getLdapConfig().getEnvironment(), (Throwable)e);
                throw new RuntimeException("Unable to connect to LDAP server", e);
            }
            catch (Exception e) {
                this.log.error("Could not retrieve Ldap object from pool", (Throwable)e);
                throw new RuntimeException("Could not retrieve Ldap object from pool", e);
            }
        }
        finally {
            if (ldap != null) {
                try {
                    this.checkIn(ldap);
                }
                catch (Exception e) {
                    this.log.error("Could not return Ldap object back to pool", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Ldap checkOut() throws Exception {
        return (Ldap)this.ldapFactory.create();
    }

    @Override
    public void checkIn(Ldap l) throws Exception {
        this.ldapFactory.destroy((BaseLdap)l);
    }
}

