/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapPoolStrategy;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapDataConnector
extends BaseDataConnector {
    private final Logger log = LoggerFactory.getLogger(LdapDataConnector.class);
    private LdapPoolStrategy ldapPool;
    private TemplateEngine filterCreator;
    private String filterTemplateName;
    private String filterTemplate;
    private String[] returnAttributes;
    private boolean noResultsIsError;
    private Cache resultsCache;
    private final LDAPValueEscapingStrategy escapingStrategy;

    public LdapDataConnector(LdapPoolStrategy pool, Cache cache) {
        this.ldapPool = pool;
        this.resultsCache = cache;
        this.escapingStrategy = new LDAPValueEscapingStrategy();
    }

    public void registerTemplate(TemplateEngine engine, String template) {
        if (this.getId() == null) {
            throw new IllegalStateException("Template cannot be registered until plugin id has been set");
        }
        this.filterCreator = engine;
        this.filterTemplate = template;
        this.filterTemplateName = "shibboleth.resolver.dc." + this.getId();
        this.filterCreator.registerTemplate(this.filterTemplateName, this.filterTemplate);
    }

    protected void clearCache() {
        if (this.isCacheResults()) {
            this.resultsCache.removeAll();
        }
    }

    public boolean isCacheResults() {
        return this.resultsCache != null;
    }

    public boolean isNoResultsIsError() {
        return this.noResultsIsError;
    }

    public void setNoResultsIsError(boolean isError) {
        this.noResultsIsError = isError;
    }

    public TemplateEngine getTemplateEngine() {
        return this.filterCreator;
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    public LdapPoolStrategy getLdapPool() {
        return this.ldapPool;
    }

    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    public void setReturnAttributes(String[] attributes) {
        this.returnAttributes = attributes;
    }

    public void setReturnAttributes(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        String[] ra = new String[st.countTokens()];
        int count = 0;
        while (count < st.countTokens()) {
            ra[count] = st.nextToken();
            ++count;
        }
        this.setReturnAttributes(ra);
    }

    @Override
    public void validate() throws AttributeResolutionException {
        Ldap ldap = null;
        try {
            try {
                ldap = this.ldapPool.checkOut();
                if (ldap == null) {
                    this.log.error("Unable to retrieve an LDAP connection");
                    throw new AttributeResolutionException("Unable to retrieve LDAP connection");
                }
                if (!ldap.connect()) {
                    throw new NamingException();
                }
            }
            catch (NamingException e) {
                this.log.error("An error occured when attempting to search the LDAP: " + ldap.getLdapConfig().getEnvironment(), (Throwable)e);
                throw new AttributeResolutionException("An error occurred when attempting to search the LDAP", e);
            }
            catch (Exception e) {
                this.log.error("Could not retrieve Ldap object from pool", (Throwable)e);
                throw new AttributeResolutionException("An error occurred when attempting to retrieve a LDAP connection from the pool", e);
            }
        }
        finally {
            if (ldap != null) {
                try {
                    this.ldapPool.checkIn(ldap);
                }
                catch (Exception e) {
                    this.log.error("Could not return Ldap object back to pool", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String searchFilter = this.filterCreator.createStatement(this.filterTemplateName, resolutionContext, this.getDependencyIds(), this.escapingStrategy);
        searchFilter = searchFilter.trim();
        this.log.debug("Search filter: {}", (Object)searchFilter);
        Map<String, BaseAttribute> attributes = this.retrieveAttributesFromCache(searchFilter);
        if (attributes == null) {
            Iterator<SearchResult> results = this.searchLdap(searchFilter);
            if (this.noResultsIsError && !results.hasNext()) {
                this.log.debug("LDAP data connector " + this.getId() + " - No result returned and connector configured to treat this as an error.");
                throw new AttributeResolutionException("No LDAP entry found for " + resolutionContext.getAttributeRequestContext().getPrincipalName());
            }
            attributes = this.buildBaseAttributes(results);
            this.cacheResult(searchFilter, attributes);
        }
        return attributes;
    }

    protected Map<String, BaseAttribute> retrieveAttributesFromCache(String searchFilter) {
        if (!this.isCacheResults()) {
            return null;
        }
        this.log.debug("LDAP data connector {} - Checking cache for search results", (Object)this.getId());
        Element cachedResult = this.resultsCache.get((Serializable)((Object)searchFilter));
        if (cachedResult != null && !cachedResult.isExpired()) {
            this.log.debug("LDAP data connector {} - Returning attributes from cache", (Object)this.getId());
            return (Map)cachedResult.getObjectValue();
        }
        this.log.debug("LDAP data connector {} - No results cached for search filter '{}'", (Object)this.getId(), (Object)searchFilter);
        return null;
    }

    protected Iterator<SearchResult> searchLdap(String searchFilter) throws AttributeResolutionException {
        this.log.debug("LDAP data connector {} - Retrieving attributes from LDAP", (Object)this.getId());
        Ldap ldap = null;
        try {
            ldap = this.ldapPool.checkOut();
            Iterator iterator = ldap.search(new SearchFilter(searchFilter), this.returnAttributes);
            return iterator;
        }
        catch (NamingException e) {
            this.log.debug("LDAP data connector " + this.getId() + " - An error occured when attempting to search the LDAP: " + ldap.getLdapConfig().getEnvironment(), (Throwable)e);
            throw new AttributeResolutionException("An error occurred when attempting to search the LDAP");
        }
        catch (Exception e) {
            this.log.debug("LDAP data connector " + this.getId() + " - Could not perform ldap search", (Throwable)e);
            throw new AttributeResolutionException("An error occurred when attempting to perform a LDAP search");
        }
        finally {
            if (ldap != null) {
                try {
                    this.ldapPool.checkIn(ldap);
                }
                catch (Exception e) {
                    this.log.error("LDAP data connector " + this.getId() + " - Could not return Ldap object back to pool", (Throwable)e);
                }
            }
        }
    }

    protected Map<String, BaseAttribute> buildBaseAttributes(Iterator<SearchResult> results) throws AttributeResolutionException {
        HashMap<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
        if (!results.hasNext()) {
            return attributes;
        }
        SearchResult sr = results.next();
        LdapAttributes ldapAttrs = null;
        try {
            ldapAttrs = LdapBeanProvider.getLdapBeanFactory().newLdapAttributes();
            ldapAttrs.addAttributes(sr.getAttributes());
        }
        catch (NamingException e) {
            this.log.debug("LDAP data connector " + this.getId() + " - Error parsing LDAP attributes", (Throwable)e);
            throw new AttributeResolutionException("Error parsing LDAP attributes", e);
        }
        for (LdapAttribute ldapAttr : ldapAttrs.getAttributes()) {
            Set values;
            this.log.debug("LDAP data connector {} - Found the following attribute: {}", (Object)this.getId(), (Object)ldapAttr);
            BasicAttribute attribute = (BasicAttribute)attributes.get(ldapAttr.getName());
            if (attribute == null) {
                attribute = new BasicAttribute(ldapAttr.getName());
                attributes.put(ldapAttr.getName(), attribute);
            }
            if ((values = ldapAttr.getValues()) == null || values.isEmpty()) continue;
            for (Object value : values) {
                if (value instanceof String) {
                    String s = (String)value;
                    if (DatatypeHelper.isEmpty((String)s)) continue;
                    ((BaseAttribute)attribute).getValues().add(DatatypeHelper.safeTrimOrNullString((String)s));
                    continue;
                }
                this.log.debug("LDAP data connector {} - Attribute {} contained a value that is not of type String", (Object)this.getId(), (Object)ldapAttr.getName());
                ((BaseAttribute)attribute).getValues().add(value);
            }
        }
        return attributes;
    }

    protected void cacheResult(String searchFilter, Map<String, BaseAttribute> attributes) {
        if (!this.isCacheResults()) {
            return;
        }
        this.log.debug("LDAP data connector {} - Caching attributes from search '{}'", (Object)this.getId(), (Object)searchFilter);
        this.resultsCache.put(new Element((Object)searchFilter, attributes));
    }

    public static enum AUTHENTICATION_TYPE {
        ANONYMOUS("none"),
        SIMPLE("simple"),
        STRONG("strong"),
        EXTERNAL("EXTERNAL"),
        DIGEST_MD5("DIGEST-MD5"),
        CRAM_MD5("CRAM-MD5"),
        GSSAPI("GSSAPI");

        private String authTypeName;

        private AUTHENTICATION_TYPE(String s) {
            this.authTypeName = s;
        }

        public String getAuthTypeName() {
            return this.authTypeName;
        }

        public static AUTHENTICATION_TYPE getAuthenticationTypeByName(String s) {
            AUTHENTICATION_TYPE type = null;
            if (ANONYMOUS.getAuthTypeName().equals(s)) {
                type = ANONYMOUS;
            } else if (SIMPLE.getAuthTypeName().equals(s)) {
                type = SIMPLE;
            } else if (STRONG.getAuthTypeName().equals(s)) {
                type = STRONG;
            } else if (EXTERNAL.getAuthTypeName().equals(s)) {
                type = EXTERNAL;
            } else if (DIGEST_MD5.getAuthTypeName().equals(s)) {
                type = DIGEST_MD5;
            } else if (CRAM_MD5.getAuthTypeName().equals(s)) {
                type = CRAM_MD5;
            } else if (GSSAPI.getAuthTypeName().equals(s)) {
                type = GSSAPI;
            }
            return type;
        }
    }

    protected class LDAPValueEscapingStrategy
    implements TemplateEngine.CharacterEscapingStrategy {
        protected LDAPValueEscapingStrategy() {
        }

        @Override
        public String escape(String value) {
            return value.replace("*", "\\*").replace("(", "\\(").replace(")", "\\)").replace("\\", "\\");
        }
    }
}

