/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import edu.internet2.middleware.shibboleth.common.util.StringResourceLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateAttributeDefinition
extends BaseAttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(TemplateAttributeDefinition.class);
    private VelocityEngine velocity;
    private String templateName;
    private String attributeTemplate;
    private List<String> sourceAttributes;

    public TemplateAttributeDefinition(VelocityEngine newVelocityEngine) {
        this.velocity = newVelocityEngine;
        this.sourceAttributes = new ArrayList<String>();
    }

    @Override
    protected BaseAttribute doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        HashMap<String, Iterator<Object>> sourceValues = new HashMap<String, Iterator<Object>>();
        BasicAttribute attribute = new BasicAttribute();
        attribute.setId(this.getId());
        int valueCount = -1;
        for (String attributeId : this.sourceAttributes) {
            Collection<Object> values = this.getValuesFromAllDependencies(resolutionContext, attributeId);
            if (valueCount == -1) {
                valueCount = values.size();
            } else if (valueCount != values.size()) {
                this.log.error("All attributes used in TemplateAttributeDefinition " + this.getId() + " must have the same number of values.");
                throw new AttributeResolutionException("All attributes used in TemplateAttributeDefinition " + this.getId() + " must have the same number of values.");
            }
            sourceValues.put(attributeId, values.iterator());
        }
        VelocityContext vCtx = new VelocityContext();
        vCtx.put("requestContext", (Object)resolutionContext.getAttributeRequestContext());
        int i = 0;
        while (i < valueCount) {
            for (String attributeId : sourceValues.keySet()) {
                vCtx.put(attributeId, ((Iterator)sourceValues.get(attributeId)).next());
            }
            try {
                this.log.debug("Populating the following {} template", (Object)this.templateName);
                StringWriter output = new StringWriter();
                Template template = this.velocity.getTemplate(this.templateName);
                template.merge((Context)vCtx, (Writer)output);
                attribute.getValues().add(output.toString());
            }
            catch (Exception e) {
                this.log.error("Unable to populate " + this.templateName + " template", (Throwable)e);
                throw new AttributeResolutionException("Unable to evaluate template", e);
            }
            ++i;
        }
        return attribute;
    }

    public void initialize() throws Exception {
        if (DatatypeHelper.isEmpty((String)this.attributeTemplate)) {
            StringBuffer defaultTemplate = new StringBuffer();
            for (String id : this.sourceAttributes) {
                defaultTemplate.append("${").append(id).append("} ");
            }
            this.attributeTemplate = defaultTemplate.toString();
        }
        this.registerTemplate();
    }

    protected void registerTemplate() {
        StringResourceRepository repository = StringResourceLoader.getRepository();
        this.templateName = "shibboleth.resolver.ad." + this.getId();
        repository.putStringResource(this.templateName, this.attributeTemplate.trim());
    }

    @Override
    public void validate() throws AttributeResolutionException {
    }

    public String getAttributeTemplate() {
        return this.attributeTemplate;
    }

    public void setAttributeTemplate(String newAttributeTemplate) {
        this.attributeTemplate = newAttributeTemplate;
    }

    public List<String> getSourceAttributes() {
        return this.sourceAttributes;
    }

    public void setSourceAttributes(List<String> newSourceAttributes) {
        this.sourceAttributes = newSourceAttributes;
    }
}

