/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfigurationManager;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.LocalizedString;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.ServiceName;
import org.opensaml.samlext.saml2mdui.DisplayName;
import org.opensaml.samlext.saml2mdui.UIInfo;
import org.opensaml.xml.XMLObject;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTagSupport
extends BodyTagSupport {
    private static final long serialVersionUID = 7988646597267865255L;
    private static Logger log = LoggerFactory.getLogger(ServiceTagSupport.class);
    private String cssClass;
    private String cssId;
    private String cssStyle;

    public void setCssClass(String value) {
        this.cssClass = value;
    }

    public void setCssId(String value) {
        this.cssId = value;
    }

    public void setCssStyle(String value) {
        this.cssStyle = value;
    }

    protected void addClassAndId(StringBuilder sb) {
        if (this.cssClass != null) {
            sb.append(" class=\"").append(this.cssClass).append('\"');
        }
        if (this.cssId != null) {
            sb.append(" id=\"").append(this.cssId).append('\"');
        }
        if (this.cssStyle != null) {
            sb.append(" style=\"").append(this.cssStyle).append('\"');
        }
    }

    protected String buildHyperLink(String url, String text) {
        Encoder esapiEncoder;
        block3: {
            esapiEncoder = ESAPI.encoder();
            try {
                URI theUrl = new URI(url);
                String scheme = theUrl.getScheme();
                if ("http".equals(scheme) || "https".equals(scheme) || "mailto".equals(scheme)) break block3;
                log.warn("The URL " + url + " contained an invalid scheme");
                return "";
            }
            catch (URISyntaxException e) {
                log.warn("The URL " + url + " was invalid: " + e.toString());
                return "";
            }
        }
        String encodedUrl = esapiEncoder.encodeForHTMLAttribute(url);
        StringBuilder sb = new StringBuilder("<a href=\"");
        sb.append(encodedUrl).append('\"');
        this.addClassAndId(sb);
        sb.append(">").append(esapiEncoder.encodeForHTML(text)).append("</a>");
        return sb.toString();
    }

    protected EntityDescriptor getSPEntityDescriptor() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ServletContext application = this.pageContext.getServletContext();
        if (request == null || application == null) {
            return null;
        }
        LoginContext loginContext = HttpServletHelper.getLoginContext(HttpServletHelper.getStorageService(application), application, request);
        RelyingPartyConfigurationManager rpConfigMngr = HttpServletHelper.getRelyingPartyConfigurationManager(application);
        if (loginContext == null || rpConfigMngr == null) {
            return null;
        }
        EntityDescriptor spEntity = HttpServletHelper.getRelyingPartyMetadata(loginContext.getRelyingPartyId(), rpConfigMngr);
        return spEntity;
    }

    protected UIInfo getSPUIInfo() {
        EntityDescriptor spEntity = this.getSPEntityDescriptor();
        if (spEntity == null) {
            return null;
        }
        for (RoleDescriptor role : spEntity.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME)) {
            Extensions exts = role.getExtensions();
            if (exts == null) continue;
            for (XMLObject object : exts.getOrderedChildren()) {
                if (!(object instanceof UIInfo)) continue;
                return (UIInfo)object;
            }
        }
        return null;
    }

    protected List<String> getBrowserLanguages() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Enumeration locales = request.getLocales();
        ArrayList<String> languages = new ArrayList<String>();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            languages.add(locale.getLanguage());
        }
        return languages;
    }

    private String getNameFromEntityId() {
        EntityDescriptor sp = this.getSPEntityDescriptor();
        if (sp == null) {
            log.debug("No relying party, nothing to display");
            return null;
        }
        try {
            URI entityId = new URI(sp.getEntityID());
            String scheme = entityId.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                return entityId.getHost();
            }
        }
        catch (URISyntaxException e) {
            return sp.getEntityID();
        }
        return sp.getEntityID();
    }

    private String getNameFromUIInfo(String lang) {
        if (this.getSPUIInfo() != null) {
            for (DisplayName name : this.getSPUIInfo().getDisplayNames()) {
                if (log.isDebugEnabled()) {
                    log.debug("Found name in UIInfo, language=" + name.getXMLLang());
                }
                if (!name.getXMLLang().equals(lang)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("returning name from UIInfo " + name.getName().getLocalString());
                }
                return name.getName().getLocalString();
            }
            if (log.isDebugEnabled()) {
                log.debug("No name in MDUI for " + lang);
            }
        }
        return null;
    }

    private String getNameFromAttributeConsumingService(String lang) {
        EntityDescriptor sp = this.getSPEntityDescriptor();
        if (sp == null) {
            log.warn("No relying party, nothing to display");
            return null;
        }
        AttributeConsumingService acs = null;
        List roles = sp.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        if (!roles.isEmpty()) {
            SPSSODescriptor spssod = (SPSSODescriptor)roles.get(0);
            acs = spssod.getDefaultAttributeConsumingService();
        }
        if (acs != null) {
            for (ServiceName name : acs.getNames()) {
                LocalizedString localName = name.getName();
                if (log.isDebugEnabled()) {
                    log.debug("Found name in AttributeConsumingService, language=" + localName.getLanguage());
                }
                if (!localName.getLanguage().equals(lang)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("returning name from AttributeConsumingService " + name.getName().getLocalString());
                }
                return localName.getLocalString();
            }
        }
        return null;
    }

    protected String getServiceName() {
        String result = null;
        if (this.getSPEntityDescriptor() == null) {
            log.debug("No relying party, nothing to display");
            return null;
        }
        List<String> languages = this.getBrowserLanguages();
        for (String lang : languages) {
            result = this.getNameFromUIInfo(lang);
            if (result != null) {
                return result;
            }
            result = this.getNameFromAttributeConsumingService(lang);
            if (result == null) continue;
            return result;
        }
        return this.getNameFromEntityId();
    }
}

