/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.util;

import edu.internet2.middleware.shibboleth.common.attribute.filtering.AttributeFilteringEngine;
import edu.internet2.middleware.shibboleth.common.attribute.provider.SAML1AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.attribute.provider.SAML2AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolver;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfigurationManager;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.SAMLMDRelyingPartyConfigurationManager;
import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContextEntry;
import edu.internet2.middleware.shibboleth.idp.profile.IdPProfileHandlerManager;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.util.URLBuilder;
import org.opensaml.util.storage.StorageService;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletHelper {
    public static final String COOKIE_DOMAIN_PARAM = "cookieDomain";
    public static final String IDP_SESSION_COOKIE = "_idp_session";
    public static final String LOGIN_CTX_KEY_NAME = "_idp_authn_lc_key";
    public static final String ATTRIBUTE_FILTER_ENGINE_SID_CTX_PARAM = "AttributeFilterEngineId";
    public static final String ATTRIBUTE_RESOLVER_SID_CTX_PARAM = "AttributeResolverId";
    public static final String LOGIN_CTX_PARTITION_CTX_PARAM = "loginContextPartitionName";
    public static final String PROFILE_HANDLER_MNGR_SID_CTX_PARAM = "ProfileHandlerMngrId";
    public static final String RP_CONFIG_MNGR_SID_CTX_PARAM = "RelyingPartyConfigurationManagerId";
    public static final String SAML1_AA_SID_CTX_PARAM = "SAML1AttributeAuthorityId";
    public static final String SAML2_AA_SID_CTX_PARAM = "SAML2AttributeAuthorityId";
    public static final String SESSION_MNGR_SID_CTX_PARAM = "SessionManagerId";
    public static final String STORAGE_SERVICE_SID_CTX_PARAM = "StorageServiceId";
    public static final String DEFAULT_ATTRIBUTE_FILTER_ENGINE_SID = "shibboleth.AttributeFilterEngine";
    public static final String DEFAULT_ATTRIBUTE_RESOLVER_SID = "shibboleth.AttributeResolver";
    public static final String DEFAULT_LOGIN_CTX_PARITION = "loginContexts";
    public static final String DEFAULT_PROFILE_HANDLER_MNGR_SID = "shibboleth.HandlerManager";
    public static final String DEFAULT_RP_CONFIG_MNGR_SID = "shibboleth.RelyingPartyConfigurationManager";
    public static final String DEFAULT_SAML1_AA_SID = "shibboleth.SAML1AttributeAuthority";
    public static final String DEFAULT_SAML2_AA_SID = "shibboleth.SAML2AttributeAuthority";
    public static final String DEFAULT_SESSION_MNGR_SID = "shibboleth.SessionManager";
    public static final String DEFAULT_STORAGE_SERVICE_SID = "shibboleth.StorageService";
    private static final Logger log = LoggerFactory.getLogger(HttpServletHelper.class);

    public static void bindLoginContext(LoginContext loginContext, HttpServletRequest httpRequest) {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        httpRequest.setAttribute(LOGIN_CTX_KEY_NAME, (Object)loginContext);
    }

    public static void bindLoginContext(LoginContext loginContext, StorageService storageService, ServletContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (storageService == null) {
            throw new IllegalArgumentException("Storage service may not be null");
        }
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (loginContext == null) {
            return;
        }
        String parition = HttpServletHelper.getContextParam(context, LOGIN_CTX_PARTITION_CTX_PARAM, DEFAULT_LOGIN_CTX_PARITION);
        String contextKey = UUID.randomUUID().toString();
        while (storageService.contains(parition, (Object)contextKey)) {
            contextKey = UUID.randomUUID().toString();
        }
        LoginContextEntry entry = new LoginContextEntry(loginContext, 1800000L);
        log.debug("Storing LoginContext to StorageService partition {}, key {}", (Object)parition, (Object)contextKey);
        storageService.put(parition, (Object)contextKey, (Object)entry);
        String cookieDomain = HttpServletHelper.getCookieDomain(context);
        Cookie contextKeyCookie = new Cookie(LOGIN_CTX_KEY_NAME, contextKey);
        contextKeyCookie.setVersion(1);
        if (cookieDomain != null) {
            contextKeyCookie.setDomain(cookieDomain);
        }
        contextKeyCookie.setPath("".equals(httpRequest.getContextPath()) ? "/" : httpRequest.getContextPath());
        contextKeyCookie.setSecure(httpRequest.isSecure());
        httpResponse.addCookie(contextKeyCookie);
        httpRequest.setAttribute(LOGIN_CTX_KEY_NAME, (Object)loginContext);
    }

    public static String getCookieDomain(ServletContext context) {
        return context.getInitParameter(COOKIE_DOMAIN_PARAM);
    }

    public static AttributeFilteringEngine<?> getAttributeFilterEnginer(ServletContext context) {
        return HttpServletHelper.getAttributeFilterEnginer(context, HttpServletHelper.getContextParam(context, ATTRIBUTE_FILTER_ENGINE_SID_CTX_PARAM, DEFAULT_ATTRIBUTE_FILTER_ENGINE_SID));
    }

    public static AttributeFilteringEngine<?> getAttributeFilterEnginer(ServletContext context, String serviceId) {
        return (AttributeFilteringEngine)context.getAttribute(serviceId);
    }

    public static AttributeResolver<?> getAttributeResolver(ServletContext context) {
        return HttpServletHelper.getAttributeResolver(context, HttpServletHelper.getContextParam(context, ATTRIBUTE_RESOLVER_SID_CTX_PARAM, DEFAULT_ATTRIBUTE_RESOLVER_SID));
    }

    public static AttributeResolver<?> getAttributeResolver(ServletContext context, String serviceId) {
        return (AttributeResolver)context.getAttribute(serviceId);
    }

    public static String getContextParam(ServletContext context, String name, String defaultValue) {
        String value = DatatypeHelper.safeTrimOrNullString((String)context.getInitParameter(name));
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static Cookie getCookie(HttpServletRequest httpRequest, String cookieName) {
        Cookie[] requestCookies = httpRequest.getCookies();
        if (requestCookies != null) {
            for (Cookie requestCookie : requestCookies) {
                if (requestCookie == null || !DatatypeHelper.safeEquals((Object)requestCookie.getName(), (Object)cookieName)) continue;
                return requestCookie;
            }
        }
        return null;
    }

    public static LoginContext getLoginContext(HttpServletRequest httpRequest) {
        ServletContext servletContext = httpRequest.getSession().getServletContext();
        StorageService<?, ?> storageService = HttpServletHelper.getStorageService(servletContext);
        return HttpServletHelper.getLoginContext(storageService, servletContext, httpRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static LoginContext getLoginContext(StorageService storageService, ServletContext context, HttpServletRequest httpRequest) {
        if (storageService == null) {
            throw new IllegalArgumentException("Storage service may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Servlet context may not be null");
        }
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        Cookie loginContextKeyCookie = HttpServletHelper.getCookie(httpRequest, LOGIN_CTX_KEY_NAME);
        if (loginContextKeyCookie == null) {
            log.debug("LoginContext key cookie was not present in request");
            return null;
        }
        String loginContextKey = DatatypeHelper.safeTrimOrNullString((String)loginContextKeyCookie.getValue());
        if (loginContextKey == null) {
            log.warn("Corrupted LoginContext Key cookie, it did not contain a value");
        }
        String partition = HttpServletHelper.getContextParam(context, LOGIN_CTX_PARTITION_CTX_PARAM, DEFAULT_LOGIN_CTX_PARITION);
        log.trace("Looking up LoginContext with key {} from StorageService parition: {}", (Object)loginContextKey, (Object)partition);
        LoginContextEntry entry = (LoginContextEntry)((Object)storageService.get(partition, (Object)loginContextKey));
        if (entry == null) {
            log.debug("No login context in storage service");
            return null;
        }
        if (entry.isExpired()) {
            log.debug("LoginContext found but it was expired");
            return null;
        }
        log.trace("Retrieved LoginContext with key {} from StorageService parition: {}", (Object)loginContextKey, (Object)partition);
        return entry.getLoginContext();
    }

    public static IdPProfileHandlerManager getProfileHandlerManager(ServletContext context) {
        return HttpServletHelper.getProfileHandlerManager(context, HttpServletHelper.getContextParam(context, PROFILE_HANDLER_MNGR_SID_CTX_PARAM, DEFAULT_PROFILE_HANDLER_MNGR_SID));
    }

    public static IdPProfileHandlerManager getProfileHandlerManager(ServletContext context, String serviceId) {
        return (IdPProfileHandlerManager)((Object)context.getAttribute(serviceId));
    }

    public static RelyingPartyConfigurationManager getRelyingPartyConfigurationManager(ServletContext context) {
        return HttpServletHelper.getRelyingPartyConfigurationManager(context, HttpServletHelper.getContextParam(context, RP_CONFIG_MNGR_SID_CTX_PARAM, DEFAULT_RP_CONFIG_MNGR_SID));
    }

    public static RelyingPartyConfigurationManager getRelyingPartyConfigurationManager(ServletContext context, String serviceId) {
        return (RelyingPartyConfigurationManager)context.getAttribute(serviceId);
    }

    public static RelyingPartyConfigurationManager getRelyingPartyConfirmationManager(ServletContext context) {
        return HttpServletHelper.getRelyingPartyConfirmationManager(context, HttpServletHelper.getContextParam(context, RP_CONFIG_MNGR_SID_CTX_PARAM, DEFAULT_RP_CONFIG_MNGR_SID));
    }

    public static RelyingPartyConfigurationManager getRelyingPartyConfirmationManager(ServletContext context, String serviceId) {
        return (RelyingPartyConfigurationManager)context.getAttribute(serviceId);
    }

    public static EntityDescriptor getRelyingPartyMetadata(String relyingPartyEntityId, RelyingPartyConfigurationManager rpConfigMngr) {
        if (rpConfigMngr instanceof SAMLMDRelyingPartyConfigurationManager) {
            SAMLMDRelyingPartyConfigurationManager samlRpConfigMngr = (SAMLMDRelyingPartyConfigurationManager)rpConfigMngr;
            try {
                return samlRpConfigMngr.getMetadataProvider().getEntityDescriptor(relyingPartyEntityId);
            }
            catch (MetadataProviderException metadataProviderException) {
                // empty catch block
            }
        }
        return null;
    }

    public static SAML1AttributeAuthority getSAML1AttributeAuthority(ServletContext context) {
        return HttpServletHelper.getSAML1AttributeAuthority(context, HttpServletHelper.getContextParam(context, SAML1_AA_SID_CTX_PARAM, DEFAULT_SAML1_AA_SID));
    }

    public static SAML1AttributeAuthority getSAML1AttributeAuthority(ServletContext context, String serviceId) {
        return (SAML1AttributeAuthority)context.getAttribute(serviceId);
    }

    public static SAML2AttributeAuthority getSAML2AttributeAuthority(ServletContext context) {
        return HttpServletHelper.getSAML2AttributeAuthority(context, HttpServletHelper.getContextParam(context, SAML2_AA_SID_CTX_PARAM, DEFAULT_SAML2_AA_SID));
    }

    public static SAML2AttributeAuthority getSAML2AttributeAuthority(ServletContext context, String serviceId) {
        return (SAML2AttributeAuthority)context.getAttribute(serviceId);
    }

    public static SessionManager<Session> getSessionManager(ServletContext context) {
        return HttpServletHelper.getSessionManager(context, HttpServletHelper.getContextParam(context, SESSION_MNGR_SID_CTX_PARAM, DEFAULT_SESSION_MNGR_SID));
    }

    public static SessionManager<Session> getSessionManager(ServletContext context, String serviceId) {
        return (SessionManager)context.getAttribute(serviceId);
    }

    public static StorageService<?, ?> getStorageService(ServletContext context) {
        return HttpServletHelper.getStorageService(context, HttpServletHelper.getContextParam(context, STORAGE_SERVICE_SID_CTX_PARAM, DEFAULT_STORAGE_SERVICE_SID));
    }

    public static StorageService<?, ?> getStorageService(ServletContext context, String serviceId) {
        return (StorageService)context.getAttribute(serviceId);
    }

    public static Session getUserSession(HttpServletRequest httpRequest) {
        return (Session)httpRequest.getAttribute("ShibbolethIdPSession");
    }

    public static LoginContext unbindLoginContext(StorageService storageService, ServletContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        log.debug("Unbinding LoginContext");
        if (storageService == null) {
            throw new IllegalArgumentException("Storage service may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Servlet context may not be null");
        }
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        Cookie loginContextKeyCookie = HttpServletHelper.getCookie(httpRequest, LOGIN_CTX_KEY_NAME);
        if (loginContextKeyCookie == null) {
            log.debug("No LoginContext cookie available, no unbinding necessary.");
            return null;
        }
        String loginContextKey = DatatypeHelper.safeTrimOrNullString((String)loginContextKeyCookie.getValue());
        if (loginContextKey == null) {
            log.warn("Corrupted LoginContext Key cookie, it did not contain a value");
            return null;
        }
        log.debug("Expiring LoginContext cookie");
        loginContextKeyCookie.setMaxAge(0);
        loginContextKeyCookie.setPath("".equals(httpRequest.getContextPath()) ? "/" : httpRequest.getContextPath());
        loginContextKeyCookie.setVersion(1);
        httpResponse.addCookie(loginContextKeyCookie);
        String storageServicePartition = HttpServletHelper.getContextParam(context, LOGIN_CTX_PARTITION_CTX_PARAM, DEFAULT_LOGIN_CTX_PARITION);
        LoginContextEntry entry = (LoginContextEntry)((Object)storageService.remove(storageServicePartition, (Object)loginContextKey));
        if (entry != null && !entry.isExpired()) {
            log.debug("Removed LoginContext, with key {}, from StorageService partition {}", (Object)loginContextKey, (Object)storageServicePartition);
            return entry.getLoginContext();
        }
        return null;
    }

    public static URLBuilder getServletContextUrl(HttpServletRequest httpRequest) {
        URLBuilder urlBuilder = new URLBuilder();
        urlBuilder.setScheme(httpRequest.getScheme());
        urlBuilder.setHost(httpRequest.getServerName());
        urlBuilder.setPort(httpRequest.getServerPort());
        urlBuilder.setPath(httpRequest.getContextPath());
        return urlBuilder;
    }

    public static URLBuilder getContextRelativeUrl(HttpServletRequest httpRequest, String path) {
        URLBuilder urlBuilder = new URLBuilder();
        urlBuilder.setScheme(httpRequest.getScheme());
        urlBuilder.setHost(httpRequest.getServerName());
        urlBuilder.setPort(httpRequest.getServerPort());
        StringBuilder pathBuilder = new StringBuilder();
        if (!"".equals(httpRequest.getContextPath())) {
            pathBuilder.append(httpRequest.getContextPath());
        }
        if (!path.startsWith("/")) {
            pathBuilder.append("/");
        }
        pathBuilder.append(DatatypeHelper.safeTrim((String)path));
        urlBuilder.setPath(pathBuilder.toString());
        return urlBuilder;
    }
}

