/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml2;

import edu.internet2.middleware.shibboleth.idp.profile.saml2.SSOProfileHandler;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.Configuration;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml2.binding.decoding.BaseSAML2MessageDecoder;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsolicitedSSODecoder
extends BaseSAML2MessageDecoder
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(UnsolicitedSSODecoder.class);
    private String defaultBinding;
    private SAMLObjectBuilder<AuthnRequest> authnRequestBuilder;
    private SAMLObjectBuilder<Issuer> issuerBuilder;
    private SAMLObjectBuilder<NameIDPolicy> nipBuilder;
    private IdentifierGenerator idGenerator;

    public UnsolicitedSSODecoder(IdentifierGenerator identifierGenerator) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        this.authnRequestBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        this.issuerBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        this.nipBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        this.idGenerator = identifierGenerator;
        this.defaultBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    public String getBindingURI() {
        return "urn:mace:shibboleth:2.0:profiles:AuthnRequest";
    }

    protected boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext samlMsgCtx) {
        return false;
    }

    protected String getIntendedDestinationEndpointURI(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        return null;
    }

    public String getDefaultBinding() {
        return this.defaultBinding;
    }

    public void setDefaultBinding(String binding) {
        this.defaultBinding = binding;
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext instanceof SSOProfileHandler.SSORequestContext)) {
            this.log.warn("Invalid message context type, this decoder only supports SSORequestContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only supports SSORequestContext");
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.warn("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        SSOProfileHandler.SSORequestContext requestContext = (SSOProfileHandler.SSORequestContext)messageContext;
        HTTPInTransport transport = (HTTPInTransport)messageContext.getInboundMessageTransport();
        String providerId = DatatypeHelper.safeTrimOrNullString((String)transport.getParameterValue("providerId"));
        if (providerId == null) {
            this.log.warn("No providerId parameter given in unsolicited SSO authentication request.");
            throw new MessageDecodingException("No providerId parameter given in unsolicited SSO authentication request.");
        }
        requestContext.setRelayState(DatatypeHelper.safeTrimOrNullString((String)transport.getParameterValue("target")));
        String timeStr = DatatypeHelper.safeTrimOrNullString((String)transport.getParameterValue("time"));
        String sessionID = ((HttpServletRequestAdapter)transport).getWrappedRequest().getRequestedSessionId();
        String binding = null;
        String acsURL = DatatypeHelper.safeTrimOrNullString((String)transport.getParameterValue("shire"));
        if (acsURL == null) {
            acsURL = this.lookupACSURL(requestContext.getMetadataProvider(), providerId);
            if (acsURL == null) {
                this.log.warn("Unable to resolve SP ACS URL for AuthnRequest construction for entityID: {}", (Object)providerId);
                throw new MessageDecodingException("Unable to resolve SP ACS URL for AuthnRequest construction");
            }
            binding = this.defaultBinding;
        }
        AuthnRequest authnRequest = this.buildAuthnRequest(providerId, acsURL, binding, timeStr, sessionID);
        requestContext.setInboundMessage((XMLObject)authnRequest);
        requestContext.setInboundSAMLMessage((SAMLObject)authnRequest);
        this.log.debug("Mocked up SAML message");
        this.populateMessageContext((SAMLMessageContext)requestContext);
        requestContext.setUnsolicited(true);
    }

    private AuthnRequest buildAuthnRequest(String entityID, String acsURL, String acsBinding, String timeStr, String sessionID) {
        AuthnRequest authnRequest = (AuthnRequest)this.authnRequestBuilder.buildObject();
        authnRequest.setAssertionConsumerServiceURL(acsURL);
        if (acsBinding != null) {
            authnRequest.setProtocolBinding(acsBinding);
        }
        Issuer issuer = (Issuer)this.issuerBuilder.buildObject();
        issuer.setValue(entityID);
        authnRequest.setIssuer(issuer);
        NameIDPolicy nip = (NameIDPolicy)this.nipBuilder.buildObject();
        nip.setAllowCreate(Boolean.valueOf(true));
        authnRequest.setNameIDPolicy(nip);
        if (timeStr != null) {
            authnRequest.setIssueInstant(new DateTime(Long.parseLong(timeStr) * 1000L, (Chronology)ISOChronology.getInstanceUTC()));
            if (sessionID != null) {
                authnRequest.setID('_' + sessionID + '!' + timeStr);
            } else {
                authnRequest.setID(this.idGenerator.generateIdentifier());
            }
        } else {
            authnRequest.setID(this.idGenerator.generateIdentifier());
            authnRequest.setIssueInstant(new DateTime());
        }
        return authnRequest;
    }

    private String lookupACSURL(MetadataProvider mdProvider, String entityId) throws MessageDecodingException {
        SPSSODescriptor spssoDesc = null;
        try {
            spssoDesc = (SPSSODescriptor)mdProvider.getRole(entityId, SPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
        }
        catch (MetadataProviderException e) {
            throw new MessageDecodingException("Error resolving metadata role for SP entityId: " + entityId, (Exception)((Object)e));
        }
        if (spssoDesc == null) {
            throw new MessageDecodingException("SAML 2 SPSSODescriptor could not be resolved from metadata for SP entityID: " + entityId);
        }
        BasicEndpointSelector selector = new BasicEndpointSelector();
        selector.setEntityRoleMetadata((RoleDescriptor)spssoDesc);
        selector.setEndpointType(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        selector.getSupportedIssuerBindings().add(this.defaultBinding);
        Endpoint endpoint = selector.selectEndpoint();
        if (endpoint == null || endpoint.getLocation() == null) {
            throw new MessageDecodingException("SAML 2 ACS endpoint could not be resolved from metadata for SP entityID and binding: " + entityId + " -- " + this.defaultBinding);
        }
        return endpoint.getLocation();
    }
}

