/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.servlets;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.dsml.DsmlSearch;
import edu.vt.middleware.ldap.ldif.LdifSearch;
import edu.vt.middleware.ldap.pool.AbstractLdapPool;
import edu.vt.middleware.ldap.pool.BlockingLdapPool;
import edu.vt.middleware.ldap.pool.DefaultLdapFactory;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import edu.vt.middleware.ldap.pool.SharedLdapPool;
import edu.vt.middleware.ldap.pool.SoftLimitLdapPool;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SearchServlet
extends HttpServlet {
    private static final long serialVersionUID = 1731614499970954068L;
    private final Log logger = LogFactory.getLog(SearchServlet.class);
    private OutputType output;
    private LdifSearch ldifSearch;
    private DsmlSearch dsmlv1Search;
    private DsmlSearch dsmlv2Search;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String propertiesFile = this.getInitParameter("edu.vt.middleware.ldap.servlets.propertiesFile");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.propertiesFile = " + propertiesFile));
        }
        LdapConfig ldapConfig = LdapConfig.createFromProperties(SearchServlet.class.getResourceAsStream(propertiesFile));
        String poolPropertiesFile = this.getInitParameter("edu.vt.middleware.ldap.servlets.poolPropertiesFile");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.poolPropertiesFile = " + poolPropertiesFile));
        }
        LdapPoolConfig ldapPoolConfig = LdapPoolConfig.createFromProperties(SearchServlet.class.getResourceAsStream(poolPropertiesFile));
        AbstractLdapPool ldapPool = null;
        String poolType = this.getInitParameter("edu.vt.middleware.ldap.servlets.poolType");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.poolType = " + poolType));
        }
        if (PoolType.BLOCKING == PoolType.valueOf(poolType)) {
            ldapPool = new BlockingLdapPool(ldapPoolConfig, new DefaultLdapFactory(ldapConfig));
        } else if (PoolType.SOFTLIMIT == PoolType.valueOf(poolType)) {
            ldapPool = new SoftLimitLdapPool(ldapPoolConfig, new DefaultLdapFactory(ldapConfig));
        } else if (PoolType.SHARED == PoolType.valueOf(poolType)) {
            ldapPool = new SharedLdapPool(ldapPoolConfig, new DefaultLdapFactory(ldapConfig));
        } else {
            throw new ServletException("Unknown pool type: " + poolType);
        }
        ldapPool.initialize();
        this.ldifSearch = new LdifSearch(ldapPool);
        this.dsmlv1Search = new DsmlSearch(ldapPool);
        this.dsmlv1Search.setVersion(DsmlSearch.Version.ONE);
        this.dsmlv2Search = new DsmlSearch(ldapPool);
        this.dsmlv2Search.setVersion(DsmlSearch.Version.TWO);
        String outputType = this.getInitParameter("edu.vt.middleware.ldap.servlets.outputFormat");
        if (outputType == null) {
            outputType = "DSML";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.outputFormat = " + outputType));
        }
        this.output = OutputType.valueOf(outputType);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Performing search: " + request.getParameter("query") + " for attributes: " + request.getParameter("attrs")));
        }
        try {
            if (this.output == OutputType.LDIF) {
                response.setContentType("text/plain");
                this.ldifSearch.search(request.getParameter("query"), request.getParameterValues("attrs"), new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream())));
            } else {
                String content = request.getParameter("content-type");
                if (content != null && content.equalsIgnoreCase("text")) {
                    response.setContentType("text/plain");
                } else {
                    response.setContentType("text/xml");
                }
                String dsmlVersion = request.getParameter("dsml-version");
                if ("2".equals(dsmlVersion)) {
                    this.dsmlv2Search.search(request.getParameter("query"), request.getParameterValues("attrs"), new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream())));
                } else {
                    this.dsmlv1Search.search(request.getParameter("query"), request.getParameterValues("attrs"), new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream())));
                }
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Error performing search", (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.ldifSearch.close();
        }
        finally {
            super.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OutputType {
        LDIF,
        DSML;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PoolType {
        BLOCKING,
        SOFTLIMIT,
        SHARED;

    }
}

