/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.pool;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.pool.AbstractLdapFactory;
import java.io.InputStream;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLdapFactory
extends AbstractLdapFactory<Ldap> {
    private LdapConfig config;
    private boolean connectOnCreate = true;

    public DefaultLdapFactory() {
        this.config = LdapConfig.createFromProperties(null);
        this.config.makeImmutable();
    }

    public DefaultLdapFactory(InputStream is) {
        this.config = LdapConfig.createFromProperties(is);
        this.config.makeImmutable();
    }

    public DefaultLdapFactory(LdapConfig lc) {
        this.config = lc;
        this.config.makeImmutable();
    }

    public boolean getConnectOnCreate() {
        return this.connectOnCreate;
    }

    public void setConnectOnCreate(boolean b) {
        this.connectOnCreate = b;
    }

    @Override
    public Ldap create() {
        Ldap l = new Ldap(this.config);
        if (this.connectOnCreate) {
            try {
                l.connect();
            }
            catch (NamingException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)"unabled to connect to the ldap", (Throwable)e);
                }
                l = null;
            }
        }
        return l;
    }

    @Override
    public void destroy(Ldap l) {
        l.close();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("destroyed ldap object: " + l));
        }
    }
}

