/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.pool;

import edu.vt.middleware.ldap.BaseLdap;
import edu.vt.middleware.ldap.pool.LdapActivationException;
import edu.vt.middleware.ldap.pool.LdapFactory;
import edu.vt.middleware.ldap.pool.LdapPool;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import edu.vt.middleware.ldap.pool.LdapPoolException;
import edu.vt.middleware.ldap.pool.LdapValidationException;
import edu.vt.middleware.ldap.pool.PrunePoolTask;
import edu.vt.middleware.ldap.pool.ValidatePoolTask;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLdapPool<T extends BaseLdap>
implements LdapPool<T> {
    protected final ReentrantLock poolLock = new ReentrantLock();
    protected final Condition poolNotEmpty = this.poolLock.newCondition();
    protected final ReentrantLock checkInLock = new ReentrantLock();
    protected final ReentrantLock checkOutLock = new ReentrantLock();
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Queue<PooledLdap<T>> available = new LinkedList<PooledLdap<T>>();
    protected Queue<PooledLdap<T>> active = new LinkedList<PooledLdap<T>>();
    protected LdapPoolConfig poolConfig;
    protected LdapFactory<T> ldapFactory;
    private Timer poolTimer = new Timer(true);

    public AbstractLdapPool(LdapPoolConfig lpc, LdapFactory<T> lf) {
        this.poolConfig = lpc;
        this.poolConfig.makeImmutable();
        this.ldapFactory = lf;
    }

    @Override
    public LdapPoolConfig getLdapPoolConfig() {
        return this.poolConfig;
    }

    @Override
    public void setPoolTimer(Timer t) {
        this.poolTimer = t;
    }

    @Override
    public void initialize() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"beginning pool initialization");
        }
        this.poolTimer.scheduleAtFixedRate(new PrunePoolTask(this), this.poolConfig.getPruneTimerPeriod(), this.poolConfig.getPruneTimerPeriod());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"prune pool task scheduled");
        }
        this.poolTimer.scheduleAtFixedRate(new ValidatePoolTask(this), this.poolConfig.getValidateTimerPeriod(), this.poolConfig.getValidateTimerPeriod());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"validate pool task scheduled");
        }
        this.initializePool();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("pool initialized to size " + this.available.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePool() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("checking ldap pool size >= " + this.poolConfig.getMinPoolSize()));
        }
        this.poolLock.lock();
        try {
            for (int count = 0; this.available.size() < this.poolConfig.getMinPoolSize() && count < this.poolConfig.getMinPoolSize() * 2; ++count) {
                T t = this.createAvailable();
                if (!this.poolConfig.isValidateOnCheckIn()) continue;
                if (this.ldapFactory.validate(t)) {
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)("ldap object passed initialize validation: " + t));
                    continue;
                }
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("ldap object failed initialize validation: " + t));
                }
                this.removeAvailable(t);
            }
            if (this.available.size() == 0 && this.poolConfig.getMinPoolSize() > 0) {
                throw new IllegalStateException("Could not initialize pool");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.poolLock.lock();
        try {
            PooledLdap<T> pl;
            while (this.available.size() > 0) {
                pl = this.available.remove();
                this.ldapFactory.destroy(pl.getLdap());
            }
            while (this.active.size() > 0) {
                pl = this.active.remove();
                this.ldapFactory.destroy(pl.getLdap());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"pool closed");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        this.poolTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T createAvailable() {
        T t = this.ldapFactory.create();
        if (t != null) {
            PooledLdap<T> pl = new PooledLdap<T>(t);
            this.poolLock.lock();
            try {
                this.available.add(pl);
            }
            finally {
                this.poolLock.unlock();
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"unable to create available ldap object");
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T createActive() {
        T t = this.ldapFactory.create();
        if (t != null) {
            PooledLdap<T> pl = new PooledLdap<T>(t);
            this.poolLock.lock();
            try {
                this.active.add(pl);
            }
            finally {
                this.poolLock.unlock();
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"unable to create active ldap object");
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T createAvailableAndActive() {
        T t = this.ldapFactory.create();
        if (t != null) {
            PooledLdap<T> pl = new PooledLdap<T>(t);
            this.poolLock.lock();
            try {
                this.available.add(pl);
                this.active.add(pl);
            }
            finally {
                this.poolLock.unlock();
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"unable to create available and active ldap object");
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAvailable(T t) {
        boolean destroy = false;
        PooledLdap<T> pl = new PooledLdap<T>(t);
        this.poolLock.lock();
        try {
            if (this.available.remove(pl)) {
                destroy = true;
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("attempt to remove unknown available ldap object: " + t));
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("removing available ldap object: " + t));
            }
            this.ldapFactory.destroy(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeActive(T t) {
        boolean destroy = false;
        PooledLdap<T> pl = new PooledLdap<T>(t);
        this.poolLock.lock();
        try {
            if (this.active.remove(pl)) {
                destroy = true;
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("attempt to remove unknown active ldap object: " + t));
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("removing active ldap object: " + t));
            }
            this.ldapFactory.destroy(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAvailableAndActive(T t) {
        boolean destroy = false;
        PooledLdap<T> pl = new PooledLdap<T>(t);
        this.poolLock.lock();
        try {
            if (this.available.remove(pl)) {
                destroy = true;
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("attempt to remove unknown available ldap object: " + t));
            }
            if (this.active.remove(pl)) {
                destroy = true;
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("attempt to remove unknown active ldap object: " + t));
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("removing active ldap object: " + t));
            }
            this.ldapFactory.destroy(t);
        }
    }

    protected void activateAndValidate(T t) throws LdapPoolException {
        if (!this.ldapFactory.activate(t)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("ldap object failed activation: " + t));
            }
            this.removeAvailableAndActive(t);
            throw new LdapActivationException("Activation of ldap object failed");
        }
        if (this.poolConfig.isValidateOnCheckOut() && !this.ldapFactory.validate(t)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("ldap object failed check out validation: " + t));
            }
            this.removeAvailableAndActive(t);
            throw new LdapValidationException("Validation of ldap object failed");
        }
    }

    protected boolean validateAndPassivate(T t) {
        boolean valid = false;
        if (this.poolConfig.isValidateOnCheckIn()) {
            if (!this.ldapFactory.validate(t)) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("ldap object failed check in validation: " + t));
                }
            } else {
                valid = true;
            }
        } else {
            valid = true;
        }
        if (valid && !this.ldapFactory.passivate(t)) {
            valid = false;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("ldap object failed activation: " + t));
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prune() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("waiting for pool lock to prune " + this.poolLock.getQueueLength()));
        }
        this.poolLock.lock();
        try {
            if (this.active.size() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("pruning pool of size " + this.available.size()));
                }
                while (this.available.size() > this.poolConfig.getMinPoolSize()) {
                    PooledLdap<T> pl = this.available.peek();
                    long time = System.currentTimeMillis() - pl.getCreatedTime();
                    if (time <= this.poolConfig.getExpirationTime()) break;
                    pl = this.available.remove();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("removing " + pl.getLdap() + " in the pool for " + time + "ms"));
                    }
                    this.ldapFactory.destroy(pl.getLdap());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("pool size pruned to " + this.available.size()));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"pool is currently active, no objects pruned");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() {
        this.poolLock.lock();
        try {
            if (this.active.size() == 0) {
                if (this.poolConfig.isValidatePeriodically()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("validate for pool of size " + this.available.size()));
                    }
                    LinkedList<PooledLdap> remove = new LinkedList<PooledLdap>();
                    for (PooledLdap pooledLdap : this.available) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("validating " + pooledLdap.getLdap()));
                        }
                        if (this.ldapFactory.validate(pooledLdap.getLdap())) {
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace((Object)("ldap object passed validation: " + pooledLdap.getLdap()));
                            continue;
                        }
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("ldap object failed validation: " + pooledLdap.getLdap()));
                        }
                        remove.add(pooledLdap);
                    }
                    for (PooledLdap pooledLdap : remove) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("removing " + pooledLdap.getLdap() + " from the pool"));
                        }
                        this.available.remove(pooledLdap);
                        this.ldapFactory.destroy(pooledLdap.getLdap());
                    }
                }
                this.initializePool();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("pool size after validation is " + this.available.size()));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"pool is currently active, no validation performed");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public int availableCount() {
        return this.available.size();
    }

    @Override
    public int activeCount() {
        return this.active.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PooledLdap<T extends BaseLdap> {
        protected static final int HASH_CODE_SEED = 89;
        private T ldap;
        private long createdTime;

        public PooledLdap(T t) {
            this.ldap = t;
            this.createdTime = System.currentTimeMillis();
        }

        public T getLdap() {
            return this.ldap;
        }

        public long getCreatedTime() {
            return this.createdTime;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o == this || this.getClass() == o.getClass() && o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            int hc = 89;
            if (this.ldap != null) {
                hc += this.ldap.hashCode();
            }
            return hc;
        }
    }
}

