/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.handler.CopySearchResultHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSearchResultHandler
extends CopySearchResultHandler {
    private boolean allowDuplicates;

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean b) {
        this.allowDuplicates = b;
    }

    @Override
    public List<SearchResult> process(SearchCriteria sc, NamingEnumeration<? extends SearchResult> en, Class<?>[] ignore) throws NamingException {
        return this.mergeResults(super.process(sc, en, ignore));
    }

    @Override
    public List<SearchResult> process(SearchCriteria sc, List<? extends SearchResult> l) throws NamingException {
        return this.mergeResults(super.process(sc, l));
    }

    protected List<SearchResult> mergeResults(List<SearchResult> results) throws NamingException {
        ArrayList<SearchResult> mergedResults = new ArrayList<SearchResult>();
        SearchResult mergedResult = null;
        for (SearchResult sr : results) {
            if (mergedResult == null) {
                mergedResult = sr;
                continue;
            }
            NamingEnumeration<? extends Attribute> en = sr.getAttributes().getAll();
            while (en.hasMore()) {
                Attribute newAttr = en.next();
                Attribute oldAttr = mergedResult.getAttributes().get(newAttr.getID());
                if (oldAttr == null) {
                    mergedResult.getAttributes().put(newAttr);
                    continue;
                }
                NamingEnumeration<?> newValues = newAttr.getAll();
                while (newValues.hasMore()) {
                    Object newValue = newValues.next();
                    if (this.allowDuplicates) {
                        oldAttr.add(newValue);
                        continue;
                    }
                    boolean add = true;
                    NamingEnumeration<?> existingValues = oldAttr.getAll();
                    while (existingValues.hasMore()) {
                        Object existingValue = existingValues.next();
                        if (!existingValue.equals(newValue)) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    oldAttr.add(newValue);
                }
            }
        }
        if (mergedResult != null) {
            mergedResults.add(mergedResult);
        }
        return mergedResults;
    }
}

