/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.EhCache;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.Timestamper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingletonEhCacheProvider
implements CacheProvider {
    public static final String NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME = "net.sf.ehcache.configurationResourceName";
    private static final Logger LOG = LoggerFactory.getLogger((String)SingletonEhCacheProvider.class.getName());
    private static int referenceCount;
    private CacheManager manager;

    public final Cache buildCache(String name, Properties properties) throws org.hibernate.cache.CacheException {
        try {
            Ehcache cache = this.manager.getEhcache(name);
            if (cache == null) {
                LOG.warn("Could not find a specific ehcache configuration for cache named [" + name + "]; using defaults.");
                this.manager.addCache(name);
                cache = this.manager.getEhcache(name);
                LOG.debug("started EHCache region: " + name);
            }
            return new EhCache(cache);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final long nextTimestamp() {
        return Timestamper.next();
    }

    public final void start(Properties properties) throws org.hibernate.cache.CacheException {
        String configurationResourceName = null;
        if (properties != null) {
            configurationResourceName = (String)properties.get(NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME);
        }
        if (configurationResourceName == null || configurationResourceName.length() == 0) {
            this.manager = CacheManager.create();
            ++referenceCount;
        } else {
            if (!configurationResourceName.startsWith("/")) {
                configurationResourceName = "/" + configurationResourceName;
                LOG.debug("prepending / to {}. It should be placed in the rootof the classpath rather than in a package.", (Object)configurationResourceName);
            }
            URL url = this.loadResource(configurationResourceName);
            this.manager = CacheManager.create(url);
            ++referenceCount;
        }
    }

    private URL loadResource(String configurationResourceName) {
        ClassLoader standardClassloader = ClassLoaderUtil.getStandardClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(configurationResourceName);
        }
        if (url == null) {
            url = this.getClass().getResource(configurationResourceName);
        }
        LOG.debug("Creating EhCacheProvider from a specified resource: {}. Resolved to URL: ", (Object)configurationResourceName, (Object)url);
        if (url == null) {
            LOG.warn("A configurationResourceName was set to {} but the resource could not be loaded from the classpath.Ehcache will configure itself using defaults.", (Object)configurationResourceName);
        }
        return url;
    }

    public void stop() {
        if (this.manager != null) {
            if (--referenceCount == 0) {
                this.manager.shutdown();
            }
            this.manager = null;
        }
    }

    public final boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

