/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.security;

import edu.internet2.middleware.shibboleth.common.xmlobject.ShibbolethMetadataKeyAuthority;
import java.lang.ref.SoftReference;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataPKIXValidationInformationResolver
implements PKIXValidationInformationResolver {
    public static final int KEY_AUTHORITY_VERIFY_DEPTH_DEFAULT = 1;
    private final Logger log = LoggerFactory.getLogger(MetadataPKIXValidationInformationResolver.class);
    private MetadataProvider metadata;
    private Map<MetadataCacheKey, SoftReference<List<PKIXValidationInformation>>> entityPKIXCache;
    private Map<Extensions, SoftReference<List<PKIXValidationInformation>>> extensionsCache;
    private Map<MetadataCacheKey, SoftReference<Set<String>>> entityNamesCache;
    private ReadWriteLock rwlock;

    public MetadataPKIXValidationInformationResolver(MetadataProvider metadataProvider) {
        if (metadataProvider == null) {
            throw new IllegalArgumentException("Metadata provider may not be null");
        }
        this.metadata = metadataProvider;
        this.entityPKIXCache = new HashMap<MetadataCacheKey, SoftReference<List<PKIXValidationInformation>>>();
        this.extensionsCache = new HashMap<Extensions, SoftReference<List<PKIXValidationInformation>>>();
        this.entityNamesCache = new HashMap<MetadataCacheKey, SoftReference<Set<String>>>();
        this.rwlock = new ReentrantReadWriteLock();
        if (this.metadata instanceof ObservableMetadataProvider) {
            ObservableMetadataProvider observable = (ObservableMetadataProvider)metadataProvider;
            observable.getObservers().add(new MetadataProviderObserver());
        }
    }

    public PKIXValidationInformation resolveSingle(CriteriaSet criteriaSet) throws SecurityException {
        Iterable<PKIXValidationInformation> pkixInfo = this.resolve(criteriaSet);
        if (pkixInfo.iterator().hasNext()) {
            return pkixInfo.iterator().next();
        }
        return null;
    }

    public Iterable<PKIXValidationInformation> resolve(CriteriaSet criteriaSet) throws SecurityException {
        this.checkCriteriaRequirements(criteriaSet);
        String entityID = ((EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class)).getEntityID();
        MetadataCriteria mdCriteria = (MetadataCriteria)criteriaSet.get(MetadataCriteria.class);
        QName role = mdCriteria.getRole();
        String protocol = mdCriteria.getProtocol();
        UsageCriteria usageCriteria = (UsageCriteria)criteriaSet.get(UsageCriteria.class);
        UsageType usage = null;
        usage = usageCriteria != null ? usageCriteria.getUsage() : UsageType.UNSPECIFIED;
        this.log.debug("Forcing on-demand metadata provider refresh if necessary");
        try {
            this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            // empty catch block
        }
        MetadataCacheKey cacheKey = new MetadataCacheKey(entityID, role, protocol, usage);
        List<PKIXValidationInformation> pkixInfoSet = this.retrievePKIXInfoFromCache(cacheKey);
        if (pkixInfoSet == null) {
            pkixInfoSet = this.retrievePKIXInfoFromMetadata(entityID, role, protocol, usage);
            this.cachePKIXInfo(cacheKey, pkixInfoSet);
        }
        return pkixInfoSet;
    }

    public Set<String> resolveTrustedNames(CriteriaSet criteriaSet) throws SecurityException, UnsupportedOperationException {
        this.checkCriteriaRequirements(criteriaSet);
        String entityID = ((EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class)).getEntityID();
        MetadataCriteria mdCriteria = (MetadataCriteria)criteriaSet.get(MetadataCriteria.class);
        QName role = mdCriteria.getRole();
        String protocol = mdCriteria.getProtocol();
        UsageCriteria usageCriteria = (UsageCriteria)criteriaSet.get(UsageCriteria.class);
        UsageType usage = null;
        usage = usageCriteria != null ? usageCriteria.getUsage() : UsageType.UNSPECIFIED;
        this.log.debug("Forcing on-demand metadata provider refresh if necessary");
        try {
            this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            // empty catch block
        }
        MetadataCacheKey cacheKey = new MetadataCacheKey(entityID, role, protocol, usage);
        Set<String> trustedNames = this.retrieveTrustedNamesFromCache(cacheKey);
        if (trustedNames == null) {
            trustedNames = this.retrieveTrustedNamesFromMetadata(entityID, role, protocol, usage);
            this.cacheTrustedNames(cacheKey, trustedNames);
        }
        return trustedNames;
    }

    public boolean supportsTrustedNameResolution() {
        return true;
    }

    protected ReadWriteLock getReadWriteLock() {
        return this.rwlock;
    }

    protected void checkCriteriaRequirements(CriteriaSet criteriaSet) {
        EntityIDCriteria entityCriteria = (EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class);
        MetadataCriteria mdCriteria = (MetadataCriteria)criteriaSet.get(MetadataCriteria.class);
        if (entityCriteria == null) {
            throw new IllegalArgumentException("Entity criteria must be supplied");
        }
        if (mdCriteria == null) {
            throw new IllegalArgumentException("SAML metadata criteria must be supplied");
        }
        if (DatatypeHelper.isEmpty((String)entityCriteria.getEntityID())) {
            throw new IllegalArgumentException("Entity ID criteria value must be supplied");
        }
        if (mdCriteria.getRole() == null) {
            throw new IllegalArgumentException("Metadata role criteria value must be supplied");
        }
    }

    protected List<PKIXValidationInformation> retrievePKIXInfoFromMetadata(String entityID, QName role, String protocol, UsageType usage) throws SecurityException {
        this.log.debug("Attempting to retrieve PKIX validation info from metadata for entity: {}", (Object)entityID);
        ArrayList<PKIXValidationInformation> pkixInfoSet = new ArrayList<PKIXValidationInformation>();
        List<RoleDescriptor> roleDescriptors = this.getRoleDescriptors(entityID, role, protocol);
        if (roleDescriptors == null || roleDescriptors.isEmpty()) {
            return pkixInfoSet;
        }
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            List<PKIXValidationInformation> roleInfo = this.resolvePKIXInfo(roleDescriptor);
            if (roleInfo == null || roleInfo.isEmpty()) continue;
            pkixInfoSet.addAll(roleInfo);
        }
        return pkixInfoSet;
    }

    protected List<PKIXValidationInformation> resolvePKIXInfo(RoleDescriptor roleDescriptor) throws SecurityException {
        ArrayList<PKIXValidationInformation> pkixInfoSet = new ArrayList<PKIXValidationInformation>();
        for (XMLObject current = roleDescriptor.getParent(); current != null; current = current.getParent()) {
            if (current instanceof EntityDescriptor) {
                pkixInfoSet.addAll(this.resolvePKIXInfo(((EntityDescriptor)current).getExtensions()));
                continue;
            }
            if (!(current instanceof EntitiesDescriptor)) continue;
            pkixInfoSet.addAll(this.resolvePKIXInfo(((EntitiesDescriptor)current).getExtensions()));
        }
        return pkixInfoSet;
    }

    protected List<PKIXValidationInformation> resolvePKIXInfo(Extensions extensions) throws SecurityException {
        if (extensions == null) {
            return Collections.emptyList();
        }
        List<PKIXValidationInformation> pkixInfoSet = this.retrieveExtensionsInfoFromCache(extensions);
        if (pkixInfoSet != null) {
            return pkixInfoSet;
        }
        if (this.log.isDebugEnabled()) {
            String parentName = this.getExtensionsParentName(extensions);
            if (parentName != null) {
                if (extensions.getParent() instanceof EntityDescriptor) {
                    this.log.debug("Resolving PKIX validation info for Extensions with EntityDescriptor parent: {}", (Object)parentName);
                } else if (extensions.getParent() instanceof EntitiesDescriptor) {
                    this.log.debug("Resolving PKIX validation info for Extensions with EntitiesDescriptor parent: {}", (Object)parentName);
                }
            } else {
                this.log.debug("Resolving PKIX validation info for Extensions with unidentified parent");
            }
        }
        pkixInfoSet = new ArrayList<PKIXValidationInformation>();
        List authorities = extensions.getUnknownXMLObjects(ShibbolethMetadataKeyAuthority.DEFAULT_ELEMENT_NAME);
        if (authorities == null || authorities.isEmpty()) {
            return pkixInfoSet;
        }
        for (XMLObject xmlObj : authorities) {
            PKIXValidationInformation authoritySet = this.resolvePKIXInfo((ShibbolethMetadataKeyAuthority)xmlObj);
            if (authoritySet == null) continue;
            pkixInfoSet.add(authoritySet);
        }
        this.cacheExtensionsInfo(extensions, pkixInfoSet);
        return pkixInfoSet;
    }

    protected PKIXValidationInformation resolvePKIXInfo(ShibbolethMetadataKeyAuthority keyAuthority) throws SecurityException {
        List<KeyInfo> keyInfos;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        Integer depth = keyAuthority.getVerifyDepth();
        if (depth == null) {
            depth = 1;
        }
        if ((keyInfos = keyAuthority.getKeyInfos()) == null || keyInfos.isEmpty()) {
            return null;
        }
        for (KeyInfo keyInfo : keyInfos) {
            certs.addAll(this.getX509Certificates(keyInfo));
            crls.addAll(this.getX509CRLs(keyInfo));
        }
        if (certs.isEmpty() && crls.isEmpty()) {
            return null;
        }
        return new BasicPKIXValidationInformation(certs, crls, depth);
    }

    protected List<X509Certificate> getX509Certificates(KeyInfo keyInfo) throws SecurityException {
        try {
            return KeyInfoHelper.getCertificates((KeyInfo)keyInfo);
        }
        catch (CertificateException e) {
            throw new SecurityException("Error extracting certificates from KeyAuthority KeyInfo", (Exception)e);
        }
    }

    protected List<X509CRL> getX509CRLs(KeyInfo keyInfo) throws SecurityException {
        try {
            return KeyInfoHelper.getCRLs((KeyInfo)keyInfo);
        }
        catch (CRLException e) {
            throw new SecurityException("Error extracting CRL's from KeyAuthority KeyInfo", (Exception)e);
        }
    }

    protected Set<String> retrieveTrustedNamesFromMetadata(String entityID, QName role, String protocol, UsageType usage) throws SecurityException {
        this.log.debug("Attempting to retrieve trusted names for PKIX validation from metadata for entity: {}", (Object)entityID);
        LazySet trustedNames = new LazySet();
        List<RoleDescriptor> roleDescriptors = this.getRoleDescriptors(entityID, role, protocol);
        if (roleDescriptors == null || roleDescriptors.isEmpty()) {
            return trustedNames;
        }
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            List keyDescriptors = roleDescriptor.getKeyDescriptors();
            if (keyDescriptors == null || keyDescriptors.isEmpty()) {
                return trustedNames;
            }
            for (KeyDescriptor keyDescriptor : keyDescriptors) {
                UsageType mdUsage = keyDescriptor.getUse();
                if (mdUsage == null) {
                    mdUsage = UsageType.UNSPECIFIED;
                }
                if (!this.matchUsage(mdUsage, usage) || keyDescriptor.getKeyInfo() == null) continue;
                trustedNames.addAll(this.getTrustedNames(keyDescriptor.getKeyInfo()));
            }
        }
        return trustedNames;
    }

    protected Set<String> getTrustedNames(KeyInfo keyInfo) {
        LazySet names = new LazySet();
        names.addAll(KeyInfoHelper.getKeyNames((KeyInfo)keyInfo));
        return names;
    }

    protected boolean matchUsage(UsageType metadataUsage, UsageType criteriaUsage) {
        if (metadataUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return metadataUsage == criteriaUsage;
    }

    protected List<RoleDescriptor> getRoleDescriptors(String entityID, QName role, String protocol) throws SecurityException {
        try {
            if (DatatypeHelper.isEmpty((String)protocol)) {
                return this.metadata.getRole(entityID, role);
            }
            RoleDescriptor roleDescriptor = this.metadata.getRole(entityID, role, protocol);
            if (roleDescriptor == null) {
                return null;
            }
            ArrayList<RoleDescriptor> roles = new ArrayList<RoleDescriptor>();
            roles.add(roleDescriptor);
            return roles;
        }
        catch (MetadataProviderException e) {
            this.log.error("Unable to read metadata from provider", (Throwable)e);
            throw new SecurityException("Unable to read metadata provider", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PKIXValidationInformation> retrievePKIXInfoFromCache(MetadataCacheKey cacheKey) {
        this.log.debug("Attempting to retrieve PKIX validation info from cache using index: {}", (Object)cacheKey);
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        this.log.debug("Read lock over cache acquired");
        try {
            SoftReference<List<PKIXValidationInformation>> reference;
            if (this.entityPKIXCache.containsKey(cacheKey) && (reference = this.entityPKIXCache.get(cacheKey)).get() != null) {
                this.log.debug("Retrieved PKIX validation info from cache using index: {}", (Object)cacheKey);
                List<PKIXValidationInformation> list = reference.get();
                return list;
            }
        }
        finally {
            readLock.unlock();
            this.log.debug("Read lock over cache released");
        }
        this.log.debug("Unable to retrieve PKIX validation info from cache using index: {}", (Object)cacheKey);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PKIXValidationInformation> retrieveExtensionsInfoFromCache(Extensions extensions) {
        if (this.log.isDebugEnabled()) {
            String parentName = this.getExtensionsParentName(extensions);
            if (parentName != null) {
                if (extensions.getParent() instanceof EntityDescriptor) {
                    this.log.debug("Attempting to retrieve PKIX validation info from cache for Extensions with EntityDescriptor parent: {}", (Object)parentName);
                } else if (extensions.getParent() instanceof EntitiesDescriptor) {
                    this.log.debug("Attempting to retrieve PKIX validation info from cache for Extensions with EntitiesDescriptor parent: {}", (Object)parentName);
                }
            } else {
                this.log.debug("Attempting to retrieve PKIX validation info from cache for Extensions with unidentified parent");
            }
        }
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        this.log.debug("Read lock over cache acquired");
        try {
            SoftReference<List<PKIXValidationInformation>> reference;
            if (this.extensionsCache.containsKey(extensions) && (reference = this.extensionsCache.get(extensions)).get() != null) {
                this.log.debug("Retrieved PKIX validation info from cache using index: {}", (Object)extensions);
                List<PKIXValidationInformation> list = reference.get();
                return list;
            }
        }
        finally {
            readLock.unlock();
            this.log.debug("Read lock over cache released");
        }
        this.log.debug("Unable to retrieve PKIX validation info from cache using index: {}", (Object)extensions);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> retrieveTrustedNamesFromCache(MetadataCacheKey cacheKey) {
        this.log.debug("Attempting to retrieve trusted names from cache using index: {}", (Object)cacheKey);
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        this.log.debug("Read lock over cache acquired");
        try {
            SoftReference<Set<String>> reference;
            if (this.entityNamesCache.containsKey(cacheKey) && (reference = this.entityNamesCache.get(cacheKey)).get() != null) {
                this.log.debug("Retrieved trusted names from cache using index: {}", (Object)cacheKey);
                Set<String> set = reference.get();
                return set;
            }
        }
        finally {
            readLock.unlock();
            this.log.debug("Read lock over cache released");
        }
        this.log.debug("Unable to retrieve trusted names from cache using index: {}", (Object)cacheKey);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cachePKIXInfo(MetadataCacheKey cacheKey, List<PKIXValidationInformation> pkixInfo) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        this.log.debug("Write lock over cache acquired");
        try {
            this.entityPKIXCache.put(cacheKey, new SoftReference<List<PKIXValidationInformation>>(pkixInfo));
            this.log.debug("Added new PKIX info to entity cache with key: {}", (Object)cacheKey);
        }
        finally {
            writeLock.unlock();
            this.log.debug("Write lock over cache released");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheExtensionsInfo(Extensions extensions, List<PKIXValidationInformation> pkixInfo) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        this.log.debug("Write lock over cache acquired");
        try {
            this.extensionsCache.put(extensions, new SoftReference<List<PKIXValidationInformation>>(pkixInfo));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added new PKIX info to cache for Extensions with parent: {}", (Object)this.getExtensionsParentName(extensions));
            }
        }
        finally {
            writeLock.unlock();
            this.log.debug("Write lock over cache released");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheTrustedNames(MetadataCacheKey cacheKey, Set<String> names) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        this.log.debug("Write lock over cache acquired");
        try {
            this.entityNamesCache.put(cacheKey, new SoftReference<Set<String>>(names));
            this.log.debug("Added new PKIX info to entity cache with key: {}", (Object)cacheKey);
        }
        finally {
            writeLock.unlock();
            this.log.debug("Write lock over cache released");
        }
    }

    protected String getExtensionsParentName(Extensions extensions) {
        XMLObject parent = extensions.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof EntityDescriptor) {
            return ((EntityDescriptor)parent).getEntityID();
        }
        if (extensions.getParent() instanceof EntitiesDescriptor) {
            return ((EntitiesDescriptor)parent).getName();
        }
        return null;
    }

    protected class MetadataProviderObserver
    implements ObservableMetadataProvider.Observer {
        protected MetadataProviderObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(MetadataProvider provider) {
            Lock writeLock = MetadataPKIXValidationInformationResolver.this.getReadWriteLock().writeLock();
            writeLock.lock();
            MetadataPKIXValidationInformationResolver.this.log.debug("Write lock over cache acquired");
            try {
                MetadataPKIXValidationInformationResolver.this.entityPKIXCache.clear();
                MetadataPKIXValidationInformationResolver.this.extensionsCache.clear();
                MetadataPKIXValidationInformationResolver.this.entityNamesCache.clear();
                MetadataPKIXValidationInformationResolver.this.log.info("PKIX validation info cache cleared");
            }
            finally {
                writeLock.unlock();
                MetadataPKIXValidationInformationResolver.this.log.debug("Write lock over cache released");
            }
        }
    }

    protected class MetadataCacheKey {
        private String id;
        private QName role;
        private String protocol;
        private UsageType usage;

        protected MetadataCacheKey(String entityID, QName entityRole, String entityProtocol, UsageType entityUsage) {
            if (entityID == null) {
                throw new IllegalArgumentException("Entity ID may not be null");
            }
            if (entityRole == null) {
                throw new IllegalArgumentException("Entity role may not be null");
            }
            if (entityUsage == null) {
                throw new IllegalArgumentException("Usage may not be null");
            }
            this.id = entityID;
            this.role = entityRole;
            this.protocol = entityProtocol;
            this.usage = entityUsage;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MetadataCacheKey)) {
                return false;
            }
            MetadataCacheKey other = (MetadataCacheKey)obj;
            if (!this.id.equals(other.id) || !this.role.equals(other.role) || this.usage != other.usage) {
                return false;
            }
            return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.id.hashCode();
            result = 37 * result + this.role.hashCode();
            if (this.protocol != null) {
                result = 37 * result + this.protocol.hashCode();
            }
            result = 37 * result + this.usage.hashCode();
            return result;
        }

        public String toString() {
            return String.format("[%s,%s,%s,%s]", this.id, this.role, this.protocol, this.usage);
        }
    }
}

