/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.service;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.service.AbstractServiceBeanDefinitionParser;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractReloadableServiceBeanDefinitionParser
extends AbstractServiceBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(AbstractReloadableServiceBeanDefinitionParser.class);

    @Override
    protected void doParse(Element configElement, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(configElement, parserContext, builder);
        if (configElement.hasAttributeNS(null, "configurationResourcePollingFrequency")) {
            builder.addPropertyReference("pollingTimer", configElement.getAttributeNS(null, "timerId"));
            long frequency = SpringConfigurationUtils.parseDurationToMillis("'configurationResourcePollingFrequency' on service " + configElement.getAttributeNS(null, "id"), configElement.getAttributeNS(null, "configurationResourcePollingFrequency"), 1);
            builder.addPropertyValue("pollingFrequency", (Object)frequency);
            this.log.debug("{} service configuration polling frequency: {}ms", (Object)this.getServiceId(configElement), (Object)frequency);
            int retryAttempts = 0;
            if (configElement.hasAttributeNS(null, "configurationResourcePollingRetryAttempts")) {
                retryAttempts = Integer.parseInt(DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, "configurationResourcePollingRetryAttempts")));
            }
            if (retryAttempts < 1) {
                retryAttempts = 3;
            }
            builder.addPropertyValue("pollingRetryAttempts", (Object)retryAttempts);
            this.log.debug("{} service configuration polling retry attempts: {}", (Object)this.getServiceId(configElement), (Object)retryAttempts);
        }
    }
}

