/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapPoolStrategy;
import edu.vt.middleware.ldap.BaseLdap;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.pool.BlockingLdapPool;
import edu.vt.middleware.ldap.pool.LdapFactory;
import edu.vt.middleware.ldap.pool.LdapPool;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import edu.vt.middleware.ldap.pool.SoftLimitLdapPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPoolVTStrategy
implements LdapPoolStrategy {
    private final Logger log = LoggerFactory.getLogger(LdapPoolVTStrategy.class);
    private LdapPool<Ldap> ldapPool;
    private LdapPoolConfig ldapPoolConfig;
    private LdapFactory<Ldap> ldapFactory;
    private boolean blockWhenEmpty;
    private int blockWaitTime;

    @Override
    public void setLdapPoolConfig(LdapPoolConfig config) {
        this.ldapPoolConfig = config;
    }

    @Override
    public void setLdapFactory(LdapFactory<Ldap> factory) {
        this.ldapFactory = factory;
    }

    @Override
    public void setBlockWhenEmpty(boolean block) {
        this.blockWhenEmpty = block;
    }

    public void setBlockWaitTime(int waitTime) {
        this.blockWaitTime = waitTime;
    }

    @Override
    public void initialize() {
        Ldap ldap = null;
        try {
            this.ldapPoolConfig.setPruneTimerPeriod(this.ldapPoolConfig.getValidateTimerPeriod());
            if (this.blockWhenEmpty) {
                this.ldapPool = new BlockingLdapPool(this.ldapPoolConfig, this.ldapFactory);
                ((BlockingLdapPool)this.ldapPool).setBlockWaitTime((long)this.blockWaitTime);
            } else {
                this.ldapPool = new SoftLimitLdapPool(this.ldapPoolConfig, this.ldapFactory);
            }
            this.ldapPool.initialize();
        }
        catch (Exception e) {
            this.log.error("Could not retrieve Ldap object from pool", (Throwable)e);
            throw new RuntimeException("Could not retrieve Ldap object from pool", e);
        }
        finally {
            if (ldap != null) {
                try {
                    this.checkIn(ldap);
                }
                catch (Exception e) {
                    this.log.error("Could not return Ldap object back to pool", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Ldap checkOut() throws Exception {
        return (Ldap)this.ldapPool.checkOut();
    }

    @Override
    public void checkIn(Ldap l) throws Exception {
        this.ldapPool.checkIn((BaseLdap)l);
    }
}

