/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.opensaml.saml2.common.SAML2Helper;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractMetadataProvider
extends BaseMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataProvider.class);
    private boolean initialized = false;
    private boolean failFastInitialization = true;
    private Map<String, EntityDescriptor> indexedDescriptors = new ConcurrentHashMap<String, EntityDescriptor>();
    private ParserPool parser;

    @Override
    public XMLObject getMetadata() throws MetadataProviderException {
        if (!this.isInitialized()) {
            throw new MetadataProviderException("Metadata provider has not been initialized");
        }
        XMLObject metadata = this.doGetMetadata();
        if (metadata == null) {
            this.log.debug("Metadata provider does not currently contain any metadata");
        }
        if (!this.isValid(metadata)) {
            this.log.debug("Metadata document exists, but it is no longer valid");
            return null;
        }
        return metadata;
    }

    protected abstract XMLObject doGetMetadata() throws MetadataProviderException;

    @Override
    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        if (!this.isInitialized()) {
            throw new MetadataProviderException("Metadata provider has not been initialized");
        }
        if (DatatypeHelper.isEmpty((String)name)) {
            this.log.debug("EntitiesDescriptor name was null or empty, skipping search for it");
            return null;
        }
        EntitiesDescriptor descriptor = this.doGetEntitiesDescriptor(name);
        if (descriptor == null) {
            this.log.debug("Metadata document does not contain an EntitiesDescriptor with the name {}", (Object)name);
            return null;
        }
        if (!this.isValid((XMLObject)descriptor)) {
            this.log.debug("Metadata document contained an EntitiesDescriptor with the name {}, but it was no longer valid", (Object)name);
            return null;
        }
        return descriptor;
    }

    protected EntitiesDescriptor doGetEntitiesDescriptor(String name) throws MetadataProviderException {
        XMLObject metadata = this.doGetMetadata();
        if (metadata == null) {
            this.log.debug("Metadata provider does not currently contain any metadata, unable to look for an EntitiesDescriptor with the name {}", (Object)name);
            return null;
        }
        EntitiesDescriptor descriptor = null;
        if (metadata instanceof EntitiesDescriptor) {
            descriptor = this.getEntitiesDescriptorByName(name, (EntitiesDescriptor)metadata);
        }
        return descriptor;
    }

    @Override
    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        if (!this.isInitialized()) {
            throw new MetadataProviderException("Metadata provider has not been initialized");
        }
        if (DatatypeHelper.isEmpty((String)entityID)) {
            this.log.debug("EntityDescriptor entityID was null or empty, skipping search for it");
            return null;
        }
        EntityDescriptor descriptor = this.doGetEntityDescriptor(entityID);
        if (descriptor == null) {
            this.log.debug("Metadata document does not contain an EntityDescriptor with the ID {}", (Object)entityID);
            return null;
        }
        if (!this.isValid((XMLObject)descriptor)) {
            this.log.debug("Metadata document contained an EntityDescriptor with the ID {}, but it was no longer valid", (Object)entityID);
            return null;
        }
        return descriptor;
    }

    protected EntityDescriptor doGetEntityDescriptor(String entityID) throws MetadataProviderException {
        XMLObject metadata = this.doGetMetadata();
        if (metadata == null) {
            this.log.debug("Metadata document was empty, unable to look for an EntityDescriptor with the ID {}", (Object)entityID);
            return null;
        }
        return this.getEntityDescriptorById(entityID, metadata);
    }

    @Override
    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        if (!this.isInitialized()) {
            throw new MetadataProviderException("Metadata provider has not been initialized");
        }
        if (DatatypeHelper.isEmpty((String)entityID)) {
            this.log.debug("EntityDescriptor entityID was null or empty, skipping search for roles");
            return null;
        }
        if (roleName == null) {
            this.log.debug("Role descriptor name was null, skipping search for roles");
            return null;
        }
        List<RoleDescriptor> roleDescriptors = this.doGetRole(entityID, roleName);
        if (roleDescriptors == null || roleDescriptors.isEmpty()) {
            this.log.debug("Entity descriptor {} did not contain any {} roles", (Object)entityID, (Object)roleName);
            return null;
        }
        Iterator<RoleDescriptor> roleDescItr = roleDescriptors.iterator();
        while (roleDescItr.hasNext()) {
            if (this.isValid((XMLObject)roleDescItr.next())) continue;
            this.log.debug("Metadata document contained a role of type {} for entity {}, but it was invalid", (Object)roleName, (Object)entityID);
            roleDescItr.remove();
        }
        if (roleDescriptors.isEmpty()) {
            this.log.debug("Entity descriptor {} did not contain any valid {} roles", (Object)entityID, (Object)roleName);
        }
        return roleDescriptors;
    }

    protected List<RoleDescriptor> doGetRole(String entityID, QName roleName) throws MetadataProviderException {
        EntityDescriptor entity = this.doGetEntityDescriptor(entityID);
        if (entity == null) {
            this.log.debug("Metadata document did not contain a descriptor for entity {}", (Object)entityID);
            return Collections.emptyList();
        }
        List<RoleDescriptor> descriptors = entity.getRoleDescriptors(roleName);
        if (descriptors != null && !descriptors.isEmpty()) {
            return new ArrayList<RoleDescriptor>(descriptors);
        }
        return Collections.emptyList();
    }

    @Override
    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        if (!this.isInitialized()) {
            throw new MetadataProviderException("Metadata provider has not been initialized");
        }
        if (DatatypeHelper.isEmpty((String)entityID)) {
            this.log.debug("EntityDescriptor entityID was null or empty, skipping search for role");
            return null;
        }
        if (roleName == null) {
            this.log.debug("Role descriptor name was null, skipping search for role");
            return null;
        }
        if (DatatypeHelper.isEmpty((String)supportedProtocol)) {
            this.log.debug("Supported protocol was null, skipping search for role.");
            return null;
        }
        RoleDescriptor role = this.doGetRole(entityID, roleName, supportedProtocol);
        if (role == null) {
            this.log.debug("Metadata document does not contain a role of type {} supporting protocol {} for entity {}", new Object[]{roleName, supportedProtocol, entityID});
            return null;
        }
        if (!this.isValid((XMLObject)role)) {
            this.log.debug("Metadata document contained a role of type {} supporting protocol {} for entity {}, but it was not longer valid", new Object[]{roleName, supportedProtocol, entityID});
            return null;
        }
        return role;
    }

    protected RoleDescriptor doGetRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        List<RoleDescriptor> roles = this.doGetRole(entityID, roleName);
        if (roles == null || roles.isEmpty()) {
            this.log.debug("Metadata document did not contain any role descriptors of type {} for entity {}", (Object)roleName, (Object)entityID);
            return null;
        }
        Iterator<RoleDescriptor> rolesItr = roles.iterator();
        RoleDescriptor role = null;
        while (rolesItr.hasNext()) {
            role = rolesItr.next();
            if (role == null || !role.isSupportedProtocol(supportedProtocol)) continue;
            return role;
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean isInitialized) {
        this.initialized = isInitialized;
    }

    public boolean isFailFastInitialization() {
        return this.failFastInitialization;
    }

    public void setFailFastInitialization(boolean failFast) {
        if (this.isInitialized()) {
            return;
        }
        this.failFastInitialization = failFast;
    }

    public ParserPool getParserPool() {
        return this.parser;
    }

    public void setParserPool(ParserPool pool) {
        this.parser = pool;
    }

    public synchronized void initialize() throws MetadataProviderException {
        if (this.initialized) {
            return;
        }
        try {
            this.doInitialization();
            this.initialized = true;
        }
        catch (MetadataProviderException e) {
            if (this.failFastInitialization) {
                this.log.error("Metadata provider failed to properly initializing, halting", (Throwable)e);
                throw e;
            }
            this.log.error("Metadata provider failed to properly initializing, continuing on without metadata", (Throwable)e);
        }
    }

    @Override
    public synchronized void destroy() {
        this.initialized = false;
        this.indexedDescriptors = Collections.emptyMap();
        this.parser = null;
        super.destroy();
    }

    protected void doInitialization() throws MetadataProviderException {
    }

    protected void clearDescriptorIndex() {
        this.indexedDescriptors.clear();
    }

    protected XMLObject unmarshallMetadata(InputStream metadataInput) throws UnmarshallingException {
        try {
            XMLObject metadata;
            this.log.trace("Parsing retrieved metadata into a DOM object");
            Document mdDocument = this.parser.parse(metadataInput);
            this.log.trace("Unmarshalling and caching metdata DOM");
            Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(mdDocument.getDocumentElement());
            if (unmarshaller == null) {
                String msg = "No unmarshaller registered for document element " + XMLHelper.getNodeQName((Node)mdDocument.getDocumentElement());
                this.log.error(msg);
                throw new UnmarshallingException(msg);
            }
            XMLObject xMLObject = metadata = unmarshaller.unmarshall(mdDocument.getDocumentElement());
            return xMLObject;
        }
        catch (Exception e) {
            throw new UnmarshallingException(e);
        }
        finally {
            try {
                metadataInput.close();
            }
            catch (IOException e) {}
        }
    }

    protected void filterMetadata(XMLObject metadata) throws FilterException {
        if (this.getMetadataFilter() != null) {
            this.log.debug("Applying metadata filter");
            this.getMetadataFilter().doFilter(metadata);
        }
    }

    protected void releaseMetadataDOM(XMLObject metadata) {
        if (metadata != null) {
            metadata.releaseDOM();
            metadata.releaseChildrenDOM(true);
        }
    }

    protected EntityDescriptor getEntityDescriptorById(String entityID, XMLObject metadata) {
        EntityDescriptor descriptor = null;
        this.log.debug("Searching for entity descriptor with an entity ID of {}", (Object)entityID);
        if (entityID != null && this.indexedDescriptors.containsKey(entityID)) {
            descriptor = this.indexedDescriptors.get(entityID);
            if (this.isValid((XMLObject)descriptor)) {
                this.log.trace("Entity descriptor for the ID {} was found in index cache, returning", (Object)entityID);
                return descriptor;
            }
            this.indexedDescriptors.remove(descriptor);
        }
        if (metadata != null) {
            if (metadata instanceof EntityDescriptor) {
                this.log.trace("Metadata root is an entity descriptor, checking if it's the one we're looking for.");
                descriptor = (EntityDescriptor)metadata;
                if (!DatatypeHelper.safeEquals((Object)descriptor.getEntityID(), (Object)entityID)) {
                    descriptor = null;
                }
                if (!this.isValid((XMLObject)descriptor)) {
                    this.log.trace("Found entity descriptor for entity with ID {} but it is no longer valid, skipping it.", (Object)entityID);
                    descriptor = null;
                }
            } else {
                this.log.trace("Metadata was an EntitiesDescriptor, checking if any of its descendant EntityDescriptor elements is the one we're looking for.");
                if (metadata instanceof EntitiesDescriptor) {
                    descriptor = this.getEntityDescriptorById(entityID, (EntitiesDescriptor)metadata);
                }
            }
        }
        if (descriptor != null) {
            this.log.trace("Located entity descriptor, creating an index to it for faster lookups");
            this.indexedDescriptors.put(entityID, descriptor);
        }
        return descriptor;
    }

    protected EntityDescriptor getEntityDescriptorById(String entityID, EntitiesDescriptor descriptor) {
        this.log.trace("Checking to see if EntitiesDescriptor {} contains the requested descriptor", (Object)descriptor.getName());
        List<EntityDescriptor> entityDescriptors = descriptor.getEntityDescriptors();
        if (entityDescriptors != null && !entityDescriptors.isEmpty()) {
            for (EntityDescriptor entityDescriptor : entityDescriptors) {
                this.log.trace("Checking entity descriptor with entity ID {}", (Object)entityDescriptor.getEntityID());
                if (!DatatypeHelper.safeEquals((Object)entityDescriptor.getEntityID(), (Object)entityID) || !this.isValid((XMLObject)entityDescriptor)) continue;
                return entityDescriptor;
            }
        }
        this.log.trace("Checking to see if any of the child entities descriptors contains the entity descriptor requested");
        List<EntitiesDescriptor> entitiesDescriptors = descriptor.getEntitiesDescriptors();
        if (entitiesDescriptors != null && !entitiesDescriptors.isEmpty()) {
            for (EntitiesDescriptor entitiesDescriptor : descriptor.getEntitiesDescriptors()) {
                EntityDescriptor entityDescriptor = this.getEntityDescriptorById(entityID, entitiesDescriptor);
                if (entityDescriptor == null) continue;
                return entityDescriptor;
            }
        }
        return null;
    }

    protected EntitiesDescriptor getEntitiesDescriptorByName(String name, EntitiesDescriptor rootDescriptor) {
        EntitiesDescriptor descriptor = null;
        if (DatatypeHelper.safeEquals((Object)name, (Object)rootDescriptor.getName()) && this.isValid((XMLObject)rootDescriptor)) {
            descriptor = rootDescriptor;
        } else {
            List<EntitiesDescriptor> childDescriptors = rootDescriptor.getEntitiesDescriptors();
            if (childDescriptors == null || childDescriptors.isEmpty()) {
                return null;
            }
            for (EntitiesDescriptor childDescriptor : childDescriptors) {
                if ((childDescriptor = this.getEntitiesDescriptorByName(name, childDescriptor)) == null) continue;
                descriptor = childDescriptor;
            }
        }
        return descriptor;
    }

    protected boolean isValid(XMLObject descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (!this.requireValidMetadata()) {
            return true;
        }
        return SAML2Helper.isValid(descriptor);
    }
}

