/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LdapUtil {
    private static final int READ_BUFFER_SIZE = 128;

    private LdapUtil() {
    }

    public static boolean checkCredential(Object credential) {
        boolean answer = false;
        if (credential != null) {
            byte[] array;
            if (credential instanceof String) {
                String string = (String)credential;
                if (!"".equals(string)) {
                    answer = true;
                }
            } else if (credential instanceof char[]) {
                char[] array2 = (char[])credential;
                if (array2.length != 0) {
                    answer = true;
                }
            } else if (credential instanceof byte[] && (array = (byte[])credential).length != 0) {
                answer = true;
            }
        }
        return answer;
    }

    public static String base64Encode(byte[] value) {
        String encodedValue;
        block3: {
            encodedValue = null;
            if (value != null) {
                try {
                    encodedValue = new String(Base64.encodeBase64((byte[])value), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log logger = LogFactory.getLog(LdapUtil.class);
                    if (!logger.isErrorEnabled()) break block3;
                    logger.error((Object)"Could not encode value using UTF-8");
                }
            }
        }
        return encodedValue;
    }

    public static String base64Encode(String value) {
        String encodedValue;
        block3: {
            encodedValue = null;
            if (value != null) {
                try {
                    encodedValue = LdapUtil.base64Encode(value.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    Log logger = LogFactory.getLog(LdapUtil.class);
                    if (!logger.isErrorEnabled()) break block3;
                    logger.error((Object)"Could not encode value using UTF-8");
                }
            }
        }
        return encodedValue;
    }

    public static byte[] base64Decode(String value) {
        byte[] decodedValue = null;
        if (value != null) {
            decodedValue = Base64.decodeBase64((byte[])value.getBytes());
        }
        return decodedValue;
    }

    public static byte[] readURL(URL url) throws IOException {
        return LdapUtil.readInputStream(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[128];
            while ((length = is.read(buffer)) != -1) {
                data.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            data.close();
        }
        return data.toByteArray();
    }
}

